/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.externalstorage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.fluid.IFluidStorage;
import refinedstorage.api.storage.fluid.IFluidStorageProvider;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.api.storage.item.IItemStorageProvider;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerFluid;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IPrioritizable;
import refinedstorage.tile.config.IType;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;
import refinedstorage.tile.externalstorage.FluidStorageExternal;
import refinedstorage.tile.externalstorage.ItemStorageDSU;
import refinedstorage.tile.externalstorage.ItemStorageDrawer;
import refinedstorage.tile.externalstorage.ItemStorageExternal;
import refinedstorage.tile.externalstorage.ItemStorageItemHandler;

public class TileExternalStorage
extends TileMultipartNode
implements IItemStorageProvider,
IFluidStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable,
IType {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final TileDataParameter<Integer> STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileExternalStorage>(){

        @Override
        public Integer getValue(TileExternalStorage tile) {
            int stored = 0;
            for (Object storage : tile.itemStorages) {
                stored += storage.getStored();
            }
            for (Object storage : tile.fluidStorages) {
                stored += ((FluidStorageExternal)storage).getStored();
            }
            return stored;
        }
    });
    public static final TileDataParameter<Integer> CAPACITY = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileExternalStorage>(){

        @Override
        public Integer getValue(TileExternalStorage tile) {
            int capacity = 0;
            for (Object storage : tile.itemStorages) {
                capacity += ((ItemStorageExternal)storage).getCapacity();
            }
            for (Object storage : tile.fluidStorages) {
                capacity += ((FluidStorageExternal)storage).getCapacity();
            }
            return capacity;
        }
    });
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private int priority = 0;
    private int compare = 0;
    private int mode = 0;
    private int type = 0;
    private List<ItemStorageExternal> itemStorages = new ArrayList<ItemStorageExternal>();
    private List<FluidStorageExternal> fluidStorages = new ArrayList<FluidStorageExternal>();
    private int lastDrawerCount;

    public TileExternalStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileExternalStorage.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.config.externalStorageUsage + (this.itemStorages.size() + this.fluidStorages.size()) * RefinedStorage.INSTANCE.config.externalStoragePerStorageUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        this.updateStorage(network);
        network.getItemStorage().rebuild();
        network.getFluidStorage().rebuild();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.network != null) {
            boolean itemChangeDetected = false;
            boolean fluidChangeDetected = false;
            for (ItemStorageExternal itemStorageExternal : this.itemStorages) {
                if (!itemStorageExternal.updateCache()) continue;
                itemChangeDetected = true;
            }
            for (FluidStorageExternal fluidStorageExternal : this.fluidStorages) {
                if (!fluidStorageExternal.updateCache()) continue;
                fluidChangeDetected = true;
            }
            if (itemChangeDetected) {
                this.network.getItemStorage().rebuild();
            }
            if (fluidChangeDetected) {
                this.network.getFluidStorage().rebuild();
            }
            if (this.getFacingTile() instanceof IDrawerGroup && this.lastDrawerCount != ((IDrawerGroup)this.getFacingTile()).getDrawerCount()) {
                this.lastDrawerCount = ((IDrawerGroup)this.getFacingTile()).getDrawerCount();
                this.updateStorage(this.network);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileExternalStorage.readItems((IItemHandler)this.itemFilters, 0, tag);
        TileExternalStorage.readItems((IItemHandler)this.fluidFilters, 1, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileExternalStorage.writeItems((IItemHandler)this.itemFilters, 0, tag);
        TileExternalStorage.writeItems((IItemHandler)this.fluidFilters, 1, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        return tag;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    public void updateStorage(INetworkMaster network) {
        this.itemStorages.clear();
        this.fluidStorages.clear();
        TileEntity facing = this.getFacingTile();
        if (facing instanceof IDrawerGroup) {
            IDrawerGroup group = (IDrawerGroup)facing;
            for (int i = 0; i < group.getDrawerCount(); ++i) {
                if (!group.isDrawerEnabled(i)) continue;
                this.itemStorages.add(new ItemStorageDrawer(this, group.getDrawer(i)));
            }
        } else if (facing instanceof IDrawer) {
            this.itemStorages.add(new ItemStorageDrawer(this, (IDrawer)facing));
        } else if (facing instanceof IDeepStorageUnit) {
            this.itemStorages.add(new ItemStorageDSU(this, (IDeepStorageUnit)facing));
        } else {
            IFluidHandler fluidHandler;
            IItemHandler itemHandler = TileExternalStorage.getItemHandler(facing, this.getDirection().func_176734_d());
            if (itemHandler != null) {
                this.itemStorages.add(new ItemStorageItemHandler(this, itemHandler));
            }
            if ((fluidHandler = this.getFluidHandler(facing, this.getDirection().func_176734_d())) != null) {
                for (IFluidTankProperties property : fluidHandler.getTankProperties()) {
                    this.fluidStorages.add(new FluidStorageExternal(this, fluidHandler, property));
                }
            }
        }
        network.getItemStorage().rebuild();
        network.getFluidStorage().rebuild();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        storages.addAll(this.itemStorages);
    }

    @Override
    public void addFluidStorages(List<IFluidStorage> storages) {
        storages.addAll(this.fluidStorages);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:external_storage";
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public int getStored() {
        return STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return CAPACITY.getValue();
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return TYPE;
    }

    @Override
    public int getType() {
        return this.field_145850_b.field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    public ItemHandlerBasic getItemFilters() {
        return this.itemFilters;
    }

    public ItemHandlerFluid getFluidFilters() {
        return this.fluidFilters;
    }
}

