/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.thaumcraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import mcp.mobius.waila.addons.thaumcraft.ThaumcraftModule;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HUDHandlerIAspectContainer
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("thaumcraft.aspects")) {
            return currenttip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("Aspects")) {
            NBTTagList taglist = tag.func_150295_c("Aspects", 10);
            ArrayList<String> unknownAspects = new ArrayList<String>();
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound subtag = taglist.func_150305_b(i);
                String aspect = Character.toUpperCase(subtag.func_74779_i("key").charAt(0)) + subtag.func_74779_i("key").substring(1);
                String amount = String.valueOf(subtag.func_74762_e("value"));
                if (!aspect.equals("???")) {
                    currenttip.add(String.format("%s" + SpecialChars.TAB + SpecialChars.ALIGNRIGHT + SpecialChars.WHITE + "%s", aspect, amount));
                    continue;
                }
                unknownAspects.add(String.format("%s" + SpecialChars.TAB + SpecialChars.ALIGNRIGHT + SpecialChars.WHITE + "%s", aspect, amount));
            }
            currenttip.addAll(unknownAspects);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        try {
            tag.func_74782_a("Aspects", (NBTBase)new NBTTagList());
            NBTTagList aspects = tag.func_150295_c("Aspects", 10);
            ItemStack headSlot = player.field_71071_by.field_70460_b[3];
            if (headSlot == null) {
                return tag;
            }
            boolean hasReveal = ThaumcraftModule.IGoggles.isInstance(headSlot.func_77973_b());
            if (!hasReveal) {
                return tag;
            }
            HashMap knownAspects = (HashMap)ThaumcraftModule.CommonProxy_getKnownAspects.invoke(ThaumcraftModule.Thaumcraft_proxy.get(null), new Object[0]);
            LinkedHashMap playerAspects = (LinkedHashMap)ThaumcraftModule.AspectList_aspects.get(knownAspects.get(player.func_70005_c_()));
            LinkedHashMap tileAspects = new LinkedHashMap();
            if (ThaumcraftModule.IAspectContainer.isInstance(te)) {
                tileAspects = (LinkedHashMap)ThaumcraftModule.AspectList_aspects.get(ThaumcraftModule.IAspectContainer_getAspects.invoke((Object)te, new Object[0]));
            } else if (ThaumcraftModule.TileAlchemyFurnace.isInstance(te)) {
                tileAspects = (LinkedHashMap)ThaumcraftModule.AspectList_aspects.get(ThaumcraftModule.TileAlchemyFurnace_aspects.get(te));
            }
            for (Object o : tileAspects.keySet()) {
                NBTTagCompound cmptag;
                if ((Integer)tileAspects.get(o) <= 0) continue;
                if (playerAspects.containsKey(o)) {
                    cmptag = new NBTTagCompound();
                    cmptag.func_74778_a("key", (String)ThaumcraftModule.Aspect_tag.get(o));
                    cmptag.func_74768_a("value", ((Integer)tileAspects.get(o)).intValue());
                    aspects.func_74742_a((NBTBase)cmptag);
                    continue;
                }
                cmptag = new NBTTagCompound();
                cmptag.func_74778_a("key", "???");
                cmptag.func_74768_a("value", ((Integer)tileAspects.get(o)).intValue());
                aspects.func_74742_a((NBTBase)cmptag);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tag;
    }
}

