/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.gui.RenderGlowEffect;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWorldLastEventHandler {
    private static final ResourceLocation yellowglow = new ResourceLocation("rftools", "textures/blocks/yellowglow.png");

    public static void tick(RenderWorldLastEvent evt) {
        RenderWorldLastEventHandler.renderHilightedBlock(evt);
        RenderWorldLastEventHandler.renderProtectedBlocks(evt);
    }

    private static void renderProtectedBlocks(RenderWorldLastEvent evt) {
        GlobalCoordinate current;
        int mode;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP p = mc.field_71439_g;
        ItemStack heldItem = p.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem == null) {
            return;
        }
        if (heldItem.func_77973_b() == ModItems.smartWrenchItem) {
            BlockProtectorTileEntity blockProtectorTileEntity;
            Set<BlockPos> coordinates;
            TileEntity te;
            GlobalCoordinate current2;
            if (SmartWrenchItem.getCurrentMode(heldItem) == SmartWrenchMode.MODE_SELECT && (current2 = SmartWrenchItem.getCurrentBlock(heldItem)) != null && current2.getDimension() == mc.field_71441_e.field_73011_w.getDimension() && (te = mc.field_71441_e.func_175625_s(current2.getCoordinate())) instanceof BlockProtectorTileEntity && !(coordinates = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).getProtectedBlocks()).isEmpty()) {
                RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, te.func_174877_v(), coordinates);
            }
        } else if (heldItem.func_77973_b() == BuilderSetup.shapeCardItem && ((mode = ShapeCardItem.getMode(heldItem)) == 1 || mode == 2) && (current = ShapeCardItem.getCurrentBlock(heldItem)) != null && current.getDimension() == mc.field_71441_e.field_73011_w.getDimension()) {
            HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
            coordinates.add(new BlockPos(0, 0, 0));
            if (mode == 2) {
                BlockPos cur = current.getCoordinate();
                BlockPos c = ShapeCardItem.getCorner1(heldItem);
                if (c != null) {
                    coordinates.add(new BlockPos(c.func_177958_n() - cur.func_177958_n(), c.func_177956_o() - cur.func_177956_o(), c.func_177952_p() - cur.func_177952_p()));
                }
            }
            RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, current.getCoordinate(), coordinates);
        }
    }

    private static void renderHighlightedBlocks(RenderWorldLastEvent evt, EntityPlayerSP p, BlockPos base, Set<BlockPos> coordinates) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179098_w();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(yellowglow);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (BlockPos coordinate : coordinates) {
            float x = base.func_177958_n() + coordinate.func_177958_n();
            float y = base.func_177956_o() + coordinate.func_177956_o();
            float z = base.func_177952_p() + coordinate.func_177952_p();
            buffer.func_178969_c(buffer.field_179004_l + (double)x, buffer.field_179005_m + (double)y, buffer.field_179002_n + (double)z);
            RenderGlowEffect.addSideFullTexture((VertexBuffer)buffer, (int)EnumFacing.UP.ordinal(), (float)1.1f, (float)-0.05f);
            RenderGlowEffect.addSideFullTexture((VertexBuffer)buffer, (int)EnumFacing.DOWN.ordinal(), (float)1.1f, (float)-0.05f);
            RenderGlowEffect.addSideFullTexture((VertexBuffer)buffer, (int)EnumFacing.NORTH.ordinal(), (float)1.1f, (float)-0.05f);
            RenderGlowEffect.addSideFullTexture((VertexBuffer)buffer, (int)EnumFacing.SOUTH.ordinal(), (float)1.1f, (float)-0.05f);
            RenderGlowEffect.addSideFullTexture((VertexBuffer)buffer, (int)EnumFacing.WEST.ordinal(), (float)1.1f, (float)-0.05f);
            RenderGlowEffect.addSideFullTexture((VertexBuffer)buffer, (int)EnumFacing.EAST.ordinal(), (float)1.1f, (float)-0.05f);
            buffer.func_178969_c(buffer.field_179004_l - (double)x, buffer.field_179005_m - (double)y, buffer.field_179002_n - (double)z);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.5f, (float)0.3f, (float)0.0f);
        GlStateManager.func_187441_d((float)2.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        for (BlockPos coordinate : coordinates) {
            RenderWorldLastEventHandler.renderHighLightedBlocksOutline(buffer, base.func_177958_n() + coordinate.func_177958_n(), base.func_177956_o() + coordinate.func_177956_o(), base.func_177952_p() + coordinate.func_177952_p());
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void renderHighLightedBlocksOutline(VertexBuffer buffer, float mx, float my, float mz) {
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181675_d();
    }

    private static void renderHilightedBlock(RenderWorldLastEvent evt) {
        BlockPos c = RFTools.instance.clientInfo.getHilightedBlock();
        if (c == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        if (time > RFTools.instance.clientInfo.getExpireHilight()) {
            RFTools.instance.clientInfo.hilightBlock(null, -1L);
            return;
        }
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        EntityPlayerSP p = mc.field_71439_g;
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        float mx = c.func_177958_n();
        float my = c.func_177956_o();
        float mz = c.func_177952_p();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderWorldLastEventHandler.renderHighLightedBlocksOutline(buffer, mx, my, mz);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }
}

