/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class BlockProtectors
extends WorldSavedData {
    public static final String PROTECTORS_NAME = "RFToolsBlockProtectors";
    private static BlockProtectors instance = null;
    private final Map<Integer, GlobalCoordinate> protectorById = new HashMap<Integer, GlobalCoordinate>();
    private final Map<GlobalCoordinate, Integer> protectorIdByCoordinate = new HashMap<GlobalCoordinate, Integer>();
    private int lastId = 0;

    public BlockProtectors(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        world.func_175693_T().func_75745_a(PROTECTORS_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            BlockProtectors.instance.protectorById.clear();
            BlockProtectors.instance.protectorIdByCoordinate.clear();
            instance = null;
        }
    }

    public static BlockProtectors getProtectors(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (BlockProtectors)world.func_175693_T().func_75742_a(BlockProtectors.class, PROTECTORS_NAME);
        if (instance == null) {
            instance = new BlockProtectors(PROTECTORS_NAME);
        }
        return instance;
    }

    public void assignId(GlobalCoordinate key, int id) {
        this.protectorById.put(id, key);
        this.protectorIdByCoordinate.put(key, id);
    }

    public int getNewId(GlobalCoordinate key) {
        if (this.protectorIdByCoordinate.containsKey(key)) {
            return this.protectorIdByCoordinate.get(key);
        }
        ++this.lastId;
        this.protectorById.put(this.lastId, key);
        this.protectorIdByCoordinate.put(key, this.lastId);
        return this.lastId;
    }

    public Integer getIdForCoordinate(GlobalCoordinate key) {
        return this.protectorIdByCoordinate.get(key);
    }

    public GlobalCoordinate getCoordinateForId(int id) {
        return this.protectorById.get(id);
    }

    public void removeDestination(BlockPos coordinate, int dimension) {
        GlobalCoordinate key = new GlobalCoordinate(coordinate, dimension);
        Integer id = this.protectorIdByCoordinate.get(key);
        if (id != null) {
            this.protectorById.remove(id);
            this.protectorIdByCoordinate.remove(key);
        }
    }

    public Collection<GlobalCoordinate> findProtectors(int x, int y, int z, int dimension, int radius) {
        ArrayList<GlobalCoordinate> protectors = new ArrayList<GlobalCoordinate>();
        for (GlobalCoordinate coordinate : this.protectorIdByCoordinate.keySet()) {
            BlockPos c;
            if (coordinate.getDimension() != dimension || Math.abs(x - (c = coordinate.getCoordinate()).func_177958_n()) > 16 + radius + 1 || Math.abs(y - c.func_177956_o()) > 16 + radius + 1 || Math.abs(z - c.func_177952_p()) > 16 + radius + 1) continue;
            protectors.add(coordinate);
        }
        return protectors;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.protectorById.clear();
        this.protectorIdByCoordinate.clear();
        this.lastId = tagCompound.func_74762_e("lastId");
        this.readDestinationsFromNBT(tagCompound);
    }

    private void readDestinationsFromNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = tagCompound.func_150295_c("blocks", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            int dim = tc.func_74762_e("dim");
            GlobalCoordinate gc = new GlobalCoordinate(c, dim);
            int id = tc.func_74762_e("id");
            this.protectorById.put(id, gc);
            this.protectorIdByCoordinate.put(gc, id);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (GlobalCoordinate destination : this.protectorIdByCoordinate.keySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            BlockPos c = destination.getCoordinate();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74768_a("dim", destination.getDimension());
            Integer id = this.protectorIdByCoordinate.get(new GlobalCoordinate(c, destination.getDimension()));
            tc.func_74768_a("id", id.intValue());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("blocks", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }
}

