/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SoundTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderBlock;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderContainer;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import mcjty.rftools.blocks.builder.SupportBlock;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String COMPONENT_NAME = "builder";
    public static final String CMD_SETMODE = "setMode";
    public static final String CMD_SETANCHOR = "setAnchor";
    public static final String CMD_SETROTATE = "setRotate";
    public static final String CMD_SETSILENT = "setSilent";
    public static final String CMD_SETSUPPORT = "setSupport";
    public static final String CMD_SETENTITIES = "setEntities";
    public static final String CMD_SETLOOP = "setLoop";
    public static final String CMD_GETLEVEL = "getLevel";
    public static final String CLIENTCMD_GETLEVEL = "getLevel";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, BuilderContainer.factory, 1);
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    public static final int MODE_SWAP = 2;
    public static final int MODE_BACK = 3;
    public static final int MODE_COLLECT = 4;
    public static final String[] MODES = new String[]{"Copy", "Move", "Swap", "Back", "Collect"};
    public static final String ROTATE_0 = "0";
    public static final String ROTATE_90 = "90";
    public static final String ROTATE_180 = "180";
    public static final String ROTATE_270 = "270";
    public static final int ANCHOR_SW = 0;
    public static final int ANCHOR_SE = 1;
    public static final int ANCHOR_NW = 2;
    public static final int ANCHOR_NE = 3;
    private int mode = 0;
    private int rotate = 0;
    private int anchor = 0;
    private boolean silent = false;
    private boolean supportMode = false;
    private boolean entityMode = false;
    private boolean loopMode = false;
    private static int currentLevel = 0;
    private int collectCounter = BuilderConfiguration.collectTimer;
    private int collectXP = 0;
    private boolean boxValid = false;
    private BlockPos minBox = null;
    private BlockPos maxBox = null;
    private BlockPos scan = null;
    private int projDx;
    private int projDy;
    private int projDz;
    private int cardType = -2;
    private ForgeChunkManager.Ticket ticket = null;
    private ChunkPos forcedChunk = null;
    private Set<BlockPos> cachedBlocks = null;
    private ChunkPos cachedChunk = null;
    private Set<Block> cachedVoidableBlocks = null;
    private static Random random = new Random();

    public BuilderTileEntity() {
        super(BuilderConfiguration.BUILDER_MAXENERGY, BuilderConfiguration.BUILDER_RECEIVEPERTICK);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private boolean isShapeCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return false;
        }
        return itemStack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    private NBTTagCompound hasCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return null;
        }
        return itemStack.func_77978_p();
    }

    private void makeSupportBlocksShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension);
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset);
        ShapeCardItem.Shape shape = ShapeCardItem.getShape(shapeCard);
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        ShapeCardItem.composeShape(shape.makeHollow(), this.field_145850_b, this.func_174877_v(), dimension, offset, blocks, BuilderConfiguration.maxBuilderDimension * 256 * BuilderConfiguration.maxBuilderDimension, false, null);
        for (BlockPos p : blocks) {
            if (!this.field_145850_b.func_175623_d(p)) continue;
            this.field_145850_b.func_180501_a(p, BuilderSetup.supportBlock.func_176223_P().func_177226_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    private void makeSupportBlocks() {
        if (this.isShapeCard()) {
            this.makeSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (world == null) {
                return;
            }
            for (int x = this.minBox.func_177958_n(); x <= this.maxBox.func_177958_n(); ++x) {
                for (int y = this.minBox.func_177956_o(); y <= this.maxBox.func_177956_o(); ++y) {
                    for (int z = this.minBox.func_177952_p(); z <= this.maxBox.func_177952_p(); ++z) {
                        BlockPos src = new BlockPos(x, y, z);
                        BlockPos dest = this.sourceToDest(src);
                        IBlockState srcState = world.func_180495_p(src);
                        Block srcBlock = srcState.func_177230_c();
                        IBlockState dstState = world.func_180495_p(dest);
                        Block dstBlock = dstState.func_177230_c();
                        int error = 0;
                        if (this.mode != 0) {
                            TileEntity srcTileEntity = world.func_175625_s(src);
                            TileEntity dstTileEntity = this.field_145850_b.func_175625_s(dest);
                            int error1 = this.isMovable((World)world, src, srcBlock, srcTileEntity);
                            int error2 = this.isMovable(this.field_145850_b, dest, dstBlock, dstTileEntity);
                            error = Math.max(error1, error2);
                        }
                        if (BuilderTileEntity.isEmpty(srcState, srcBlock) && !BuilderTileEntity.isEmpty(dstState, dstBlock)) {
                            this.field_145850_b.func_180501_a(src, BuilderSetup.supportBlock.func_176223_P().func_177226_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                        }
                        if (!BuilderTileEntity.isEmpty(dstState, dstBlock) || BuilderTileEntity.isEmpty(srcState, srcBlock)) continue;
                        this.field_145850_b.func_180501_a(dest, BuilderSetup.supportBlock.func_176223_P().func_177226_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                    }
                }
            }
        }
    }

    private void clearSupportBlocksShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension);
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset);
        ShapeCardItem.Shape shape = ShapeCardItem.getShape(shapeCard);
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        ShapeCardItem.composeShape(shape.makeHollow(), this.field_145850_b, this.func_174877_v(), dimension, offset, blocks, BuilderConfiguration.maxSpaceChamberDimension * BuilderConfiguration.maxSpaceChamberDimension * BuilderConfiguration.maxSpaceChamberDimension, false, null);
        for (BlockPos block : blocks) {
            if (this.field_145850_b.func_180495_p(block).func_177230_c() != BuilderSetup.supportBlock) continue;
            this.field_145850_b.func_175698_g(block);
        }
    }

    public void clearSupportBlocks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isShapeCard()) {
            this.clearSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            for (int x = this.minBox.func_177958_n(); x <= this.maxBox.func_177958_n(); ++x) {
                for (int y = this.minBox.func_177956_o(); y <= this.maxBox.func_177956_o(); ++y) {
                    for (int z = this.minBox.func_177952_p(); z <= this.maxBox.func_177952_p(); ++z) {
                        BlockPos dest;
                        Block dstBlock;
                        Block srcBlock;
                        BlockPos src = new BlockPos(x, y, z);
                        if (world != null && (srcBlock = world.func_180495_p(src).func_177230_c()) == BuilderSetup.supportBlock) {
                            world.func_175698_g(src);
                        }
                        if ((dstBlock = this.field_145850_b.func_180495_p(dest = this.sourceToDest(src)).func_177230_c()) != BuilderSetup.supportBlock) continue;
                        this.field_145850_b.func_175698_g(dest);
                    }
                }
            }
        }
    }

    public boolean hasLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
        this.markDirtyClient();
    }

    public boolean hasEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(boolean entityMode) {
        this.entityMode = entityMode;
        this.markDirtyClient();
    }

    public boolean hasSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
        if (supportMode) {
            this.makeSupportBlocks();
        } else {
            this.clearSupportBlocks();
        }
        this.markDirtyClient();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.markDirtyClient();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.restartScan();
            this.markDirtyClient();
        }
    }

    public void resetBox() {
        this.boxValid = false;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.anchor = anchor;
        if (this.isShapeCard()) {
            ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
            BlockPos dimension = ShapeCardItem.getDimension(shapeCard);
            BlockPos minBox = this.positionBox(dimension);
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            BlockPos offset = new BlockPos(minBox.func_177958_n() + (int)Math.ceil(dx / 2), minBox.func_177956_o() + (int)Math.ceil(dy / 2), minBox.func_177952_p() + (int)Math.ceil(dz / 2));
            NBTTagCompound tagCompound = shapeCard.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                shapeCard.func_77982_d(tagCompound);
            }
            tagCompound.func_74768_a("offsetX", offset.func_177958_n());
            tagCompound.func_74768_a("offsetY", offset.func_177956_o());
            tagCompound.func_74768_a("offsetZ", offset.func_177952_p());
        }
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    private BlockPos positionBox(BlockPos dimension) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BuilderBlock.FACING_HORIZ);
        int spanX = dimension.func_177958_n();
        int spanY = dimension.func_177956_o();
        int spanZ = dimension.func_177952_p();
        int x = 0;
        int z = 0;
        int y = -(this.anchor == 3 || this.anchor == 2 ? spanY - 1 : 0);
        switch (direction) {
            case SOUTH: {
                x = -(this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = -spanZ;
                break;
            }
            case NORTH: {
                x = 1 - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = 1;
                break;
            }
            case WEST: {
                x = 1;
                z = -(this.anchor == 3 || this.anchor == 1 ? spanZ - 1 : 0);
                break;
            }
            case EAST: {
                x = -spanX;
                z = -(this.anchor == 3 || this.anchor == 1 ? 0 : spanZ - 1);
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.rotate = rotate;
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed && (this.loopMode || powered > 0 && this.scan == null)) {
            this.restartScan();
        }
    }

    private BlockPos rotate(BlockPos c) {
        switch (this.rotate) {
            case 0: {
                return c;
            }
            case 1: {
                return new BlockPos(-c.func_177952_p(), c.func_177956_o(), c.func_177958_n());
            }
            case 2: {
                return new BlockPos(-c.func_177958_n(), c.func_177956_o(), -c.func_177952_p());
            }
            case 3: {
                return new BlockPos(c.func_177952_p(), c.func_177956_o(), -c.func_177958_n());
            }
        }
        return c;
    }

    private void createProjection(SpaceChamberRepository.SpaceChamberChannel chamberChannel) {
        BlockPos minC = this.rotate(chamberChannel.getMinCorner());
        BlockPos maxC = this.rotate(chamberChannel.getMaxCorner());
        BlockPos minCorner = new BlockPos(Math.min(minC.func_177958_n(), maxC.func_177958_n()), Math.min(minC.func_177956_o(), maxC.func_177956_o()), Math.min(minC.func_177952_p(), maxC.func_177952_p()));
        BlockPos maxCorner = new BlockPos(Math.max(minC.func_177958_n(), maxC.func_177958_n()), Math.max(minC.func_177956_o(), maxC.func_177956_o()), Math.max(minC.func_177952_p(), maxC.func_177952_p()));
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BuilderBlock.FACING_HORIZ);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int spanX = maxCorner.func_177958_n() - minCorner.func_177958_n();
        int spanY = maxCorner.func_177956_o() - minCorner.func_177956_o();
        int spanZ = maxCorner.func_177952_p() - minCorner.func_177952_p();
        switch (direction) {
            case SOUTH: {
                this.projDx = xCoord + EnumFacing.NORTH.func_176730_m().func_177958_n() - minCorner.func_177958_n() - (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + EnumFacing.NORTH.func_176730_m().func_177952_p() - minCorner.func_177952_p() - spanZ;
                break;
            }
            case NORTH: {
                this.projDx = xCoord + EnumFacing.SOUTH.func_176730_m().func_177958_n() - minCorner.func_177958_n() - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + EnumFacing.SOUTH.func_176730_m().func_177952_p() - minCorner.func_177952_p();
                break;
            }
            case WEST: {
                this.projDx = xCoord + EnumFacing.EAST.func_176730_m().func_177958_n() - minCorner.func_177958_n();
                this.projDz = zCoord + EnumFacing.EAST.func_176730_m().func_177952_p() - minCorner.func_177952_p() - (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
            case EAST: {
                this.projDx = xCoord + EnumFacing.WEST.func_176730_m().func_177958_n() - minCorner.func_177958_n() - spanX;
                this.projDz = zCoord + EnumFacing.WEST.func_176730_m().func_177952_p() - minCorner.func_177952_p() - spanZ + (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
        }
        this.projDy = yCoord - minCorner.func_177956_o() - (this.anchor == 3 || this.anchor == 2 ? spanY : 0);
    }

    private void calculateBox(NBTTagCompound cardCompound) {
        int channel = cardCompound.func_74762_e("channel");
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = -1;
        this.createProjection(chamberChannel);
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private void checkStateServerShaped() {
        float factor = this.getInfusedFactor();
        int i = 0;
        while ((float)i < (float)BuilderConfiguration.quarryBaseSpeed + factor * (float)BuilderConfiguration.quarryInfusionSpeedFactor) {
            if (this.scan != null) {
                this.handleBlockShaped();
            }
            ++i;
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.powerLevel == 0 && this.loopMode) {
            return;
        }
        if (this.scan == null) {
            return;
        }
        if (this.isShapeCard()) {
            if (this.powerLevel == 0) {
                this.chunkUnload();
                return;
            }
            this.checkStateServerShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel == null) {
            this.scan = null;
            this.func_70296_d();
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        if (this.mode == 4) {
            this.collectItems((World)world);
        } else {
            float factor = this.getInfusedFactor();
            int i = 0;
            while ((float)i < 2.0f + factor * 40.0f) {
                if (this.scan != null) {
                    this.handleBlock((World)world);
                }
                ++i;
            }
        }
    }

    private void collectItems(World world) {
        float infusedFactor;
        --this.collectCounter;
        if (this.collectCounter > 0) {
            return;
        }
        this.collectCounter = BuilderConfiguration.collectTimer;
        if (!this.loopMode) {
            this.scan = null;
        }
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        float area = (this.maxBox.func_177958_n() - this.minBox.func_177958_n() + 1) * (this.maxBox.func_177956_o() - this.minBox.func_177956_o() + 1) * (this.maxBox.func_177952_p() - this.minBox.func_177952_p() + 1);
        int rfNeeded = (int)(BuilderConfiguration.collectRFPerTickPerArea * area * (infusedFactor = (4.0f - this.getInfusedFactor()) / 4.0f)) * BuilderConfiguration.collectTimer;
        if (rfNeeded > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        AxisAlignedBB bb = new AxisAlignedBB((double)this.minBox.func_177958_n() - 0.8, (double)this.minBox.func_177956_o() - 0.8, (double)this.minBox.func_177952_p() - 0.8, (double)this.maxBox.func_177958_n() + 0.8, (double)this.maxBox.func_177956_o() + 0.8, (double)this.maxBox.func_177952_p() + 0.8);
        List items = world.func_72872_a(Entity.class, bb);
        for (Entity entity : items) {
            if (!(entity instanceof EntityItem ? this.collectItem(world, infusedFactor, (EntityItem)entity) : entity instanceof EntityXPOrb && this.collectXP(world, infusedFactor, (EntityXPOrb)entity))) continue;
            return;
        }
    }

    private boolean collectXP(World world, float infusedFactor, EntityXPOrb orb) {
        int rf;
        int xp = orb.func_70526_d();
        int rfNeeded = (int)(BuilderConfiguration.collectRFPerXP * infusedFactor * (float)xp);
        if (rfNeeded > (rf = this.getEnergyStored(EnumFacing.DOWN))) {
            return true;
        }
        this.collectXP += xp;
        int bottles = this.collectXP / 7;
        if (bottles > 0) {
            if (this.insertItem(new ItemStack(Items.field_151062_by, bottles)) == null) {
                this.collectXP %= 7;
                world.func_72900_e((Entity)orb);
                this.consumeEnergy(rfNeeded);
            } else {
                this.collectXP = 0;
            }
        }
        return false;
    }

    private boolean collectItem(World world, float infusedFactor, EntityItem item) {
        ItemStack stack = item.func_92059_d();
        int rfNeeded = (int)((float)BuilderConfiguration.collectRFPerItem * infusedFactor) * stack.field_77994_a;
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        if (rfNeeded > rf) {
            return true;
        }
        this.consumeEnergy(rfNeeded);
        world.func_72900_e((Entity)item);
        stack = this.insertItem(stack);
        if (stack != null) {
            BlockPos position = item.func_180425_c();
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), stack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
        return false;
    }

    private void calculateBoxShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        if (shapeCard == null) {
            return;
        }
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension);
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset);
        BlockPos minCorner = ShapeCardItem.getMinCorner(this.func_174877_v(), dimension, offset);
        BlockPos maxCorner = ShapeCardItem.getMaxCorner(this.func_174877_v(), dimension, offset);
        if (minCorner.func_177956_o() < 0) {
            minCorner = new BlockPos(minCorner.func_177958_n(), 0, minCorner.func_177952_p());
        } else if (minCorner.func_177956_o() > 255) {
            minCorner = new BlockPos(minCorner.func_177958_n(), 255, minCorner.func_177952_p());
        }
        if (maxCorner.func_177956_o() < 0) {
            maxCorner = new BlockPos(maxCorner.func_177958_n(), 0, maxCorner.func_177952_p());
        } else if (maxCorner.func_177956_o() > 255) {
            maxCorner = new BlockPos(maxCorner.func_177958_n(), 255, maxCorner.func_177952_p());
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = shapeCard.func_77952_i();
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks = null;
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private SpaceChamberRepository.SpaceChamberChannel calculateBox() {
        NBTTagCompound tc = this.hasCard();
        if (tc == null) {
            return null;
        }
        int channel = tc.func_74762_e("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        this.calculateBox(tc);
        if (!this.boxValid) {
            return null;
        }
        return chamberChannel;
    }

    private Set<BlockPos> getCachedBlocks(ChunkPos chunk) {
        if (chunk != null && !chunk.equals((Object)this.cachedChunk) || chunk == null && this.cachedChunk != null) {
            this.cachedBlocks = null;
        }
        if (this.cachedBlocks == null) {
            this.cachedBlocks = new HashSet<BlockPos>();
            ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
            ShapeCardItem.Shape shape = ShapeCardItem.getShape(shapeCard);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension);
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset);
            ShapeCardItem.composeShape(shape, this.field_145850_b, this.func_174877_v(), dimension, offset, this.cachedBlocks, BuilderConfiguration.maxSpaceChamberDimension * BuilderConfiguration.maxSpaceChamberDimension * BuilderConfiguration.maxSpaceChamberDimension, !ShapeCardItem.isNormalShapeCard(shapeCard), chunk);
            this.cachedChunk = chunk;
        }
        return this.cachedBlocks;
    }

    private void handleBlockShaped() {
        for (int i = 0; i < 100; ++i) {
            if (this.scan == null) {
                return;
            }
            if (this.getCachedBlocks(new ChunkPos(this.scan.func_177958_n() >> 4, this.scan.func_177952_p() >> 4)).contains(this.scan)) {
                if (!this.handleSingleBlock()) {
                    this.nextLocation();
                }
                return;
            }
            this.nextLocation();
        }
    }

    private int getCardType() {
        ItemStack card;
        if (this.cardType == -2 && (card = this.inventoryHelper.getStackInSlot(0)) != null) {
            this.cardType = card.func_77952_i();
        }
        return this.cardType;
    }

    private boolean handleSingleBlock() {
        BlockPos spos;
        IBlockState state;
        int rfNeeded;
        BlockPos srcPos = this.scan;
        int sx = this.scan.func_177958_n();
        int sy = this.scan.func_177956_o();
        int sz = this.scan.func_177952_p();
        if (!this.chunkLoad(sx, sz)) {
            return true;
        }
        switch (this.getCardType()) {
            case 1: {
                rfNeeded = (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.voidShapeCardFactor);
                break;
            }
            case 4: 
            case 7: {
                rfNeeded = (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.fortunequarryShapeCardFactor);
                break;
            }
            case 3: 
            case 6: {
                rfNeeded = (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.silkquarryShapeCardFactor);
                break;
            }
            case 2: 
            case 5: {
                rfNeeded = BuilderConfiguration.builderRfPerQuarry;
                break;
            }
            case 0: {
                rfNeeded = BuilderConfiguration.builderRfPerOperation;
                break;
            }
            default: {
                rfNeeded = 0;
            }
        }
        Block block = null;
        if (this.getCardType() != 0 && !BuilderTileEntity.isEmpty(state = this.field_145850_b.func_180495_p(spos = new BlockPos(sx, sy, sz)), block = state.func_177230_c())) {
            float hardness;
            if (block instanceof BlockDynamicLiquid || block instanceof BlockStaticLiquid) {
                hardness = 1.0f;
            } else {
                if (this.getCachedVoidableBlocks().contains(block)) {
                    rfNeeded = (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.voidShapeCardFactor);
                }
                hardness = block.func_176195_g(state, this.field_145850_b, spos);
            }
            rfNeeded *= (int)((hardness + 1.0f) * 2.0f);
        }
        if ((rfNeeded = (int)((float)rfNeeded * (3.0f - this.getInfusedFactor()) / 3.0f)) > this.getEnergyStored(EnumFacing.DOWN)) {
            return true;
        }
        switch (this.getCardType()) {
            case 1: {
                return this.voidBlock(rfNeeded, srcPos, block);
            }
            case 2: 
            case 5: {
                return this.quarryBlock(rfNeeded, srcPos, block);
            }
            case 4: 
            case 7: {
                return this.quarryBlock(rfNeeded, srcPos, block);
            }
            case 3: 
            case 6: {
                return this.silkQuarryBlock(rfNeeded, srcPos, block);
            }
            case 0: {
                return this.buildBlock(rfNeeded, srcPos);
            }
        }
        return true;
    }

    private boolean buildBlock(int rfNeeded, BlockPos srcPos) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.field_145850_b, srcPos)) {
            IBlockState state = this.consumeBlock(null);
            if (state == null) {
                return true;
            }
            this.field_145850_b.func_180501_a(srcPos, state, 3);
            if (!this.silent) {
                SoundTools.playSound((World)this.field_145850_b, (SoundEvent)state.func_177230_c().func_185467_w().field_185862_o, (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
        return false;
    }

    private Set<Block> getCachedVoidableBlocks() {
        if (this.cachedVoidableBlocks == null) {
            ItemStack card = this.inventoryHelper.getStackInSlot(0);
            this.cachedVoidableBlocks = card != null && card.func_77973_b() == BuilderSetup.shapeCardItem ? ShapeCardItem.getVoidedBlocks(card) : Collections.emptySet();
        }
        return this.cachedVoidableBlocks;
    }

    private void clearOrDirtBlock(int rfNeeded, int sx, int sy, int sz, Block block, boolean clear) {
        BlockPos spos = new BlockPos(sx, sy, sz);
        if (clear) {
            this.field_145850_b.func_175698_g(spos);
        } else {
            this.field_145850_b.func_180501_a(spos, this.getDirtOrCobble().func_176223_P(), 2);
        }
        this.consumeEnergy(rfNeeded);
        if (!this.silent) {
            SoundTools.playSound((World)this.field_145850_b, (SoundEvent)block.func_185467_w().field_185862_o, (double)sx, (double)sy, (double)sz, (double)1.0, (double)1.0);
        }
    }

    private Block getDirtOrCobble() {
        return BuilderConfiguration.quarryCobble ? Blocks.field_150347_e : Blocks.field_150346_d;
    }

    private boolean silkQuarryBlock(int rfNeeded, BlockPos srcPos, Block block) {
        IBlockState srcState = this.field_145850_b.func_180495_p(srcPos);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return false;
        }
        if (BuilderTileEntity.isEmpty(srcState, block)) {
            return false;
        }
        if (block.func_176195_g(srcState, this.field_145850_b, srcPos) >= 0.0f) {
            boolean clear = ShapeCardItem.isClearingQuarry(this.getCardType());
            if (!clear && block == this.getDirtOrCobble()) {
                return false;
            }
            if (BuilderConfiguration.quarrySkipTileEntities && this.field_145850_b.func_175625_s(srcPos) != null) {
                return false;
            }
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)DimensionManager.getWorld((int)0));
            if (block.canEntityDestroy(srcState, (IBlockAccess)this.field_145850_b, srcPos, (Entity)fakePlayer)) {
                if (this.getCachedVoidableBlocks().contains(block)) {
                    this.clearOrDirtBlock(rfNeeded, sx, sy, sz, block, clear);
                } else {
                    List<ItemStack> drops;
                    if (block.canSilkHarvest(this.field_145850_b, srcPos, srcState, (EntityPlayer)fakePlayer)) {
                        Item item = Item.func_150898_a((Block)block);
                        drops = new ArrayList();
                        if (item != null) {
                            int m = 0;
                            if (item.func_77614_k()) {
                                m = block.func_176201_c(srcState);
                            }
                            drops.add(new ItemStack(item, 1, m));
                        }
                        ForgeEventFactory.fireBlockHarvesting(drops, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)srcState, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    } else {
                        drops = block.getDrops((IBlockAccess)this.field_145850_b, srcPos, srcState, 0);
                        ForgeEventFactory.fireBlockHarvesting(drops, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)srcState, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                    }
                    if (this.checkAndInsertItems(block, drops)) {
                        this.clearOrDirtBlock(rfNeeded, sx, sy, sz, block, clear);
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean quarryBlock(int rfNeeded, BlockPos srcPos, Block block) {
        IBlockState srcState = this.field_145850_b.func_180495_p(srcPos);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return false;
        }
        if (BuilderTileEntity.isEmpty(srcState, block)) {
            return false;
        }
        if (block.func_176195_g(srcState, this.field_145850_b, srcPos) >= 0.0f) {
            boolean clear = ShapeCardItem.isClearingQuarry(this.getCardType());
            if (!clear && block == this.getDirtOrCobble()) {
                return false;
            }
            if (BuilderConfiguration.quarrySkipTileEntities && this.field_145850_b.func_175625_s(srcPos) != null) {
                return false;
            }
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)DimensionManager.getWorld((int)0));
            if (block.canEntityDestroy(srcState, (IBlockAccess)this.field_145850_b, srcPos, (Entity)fakePlayer)) {
                if (this.getCachedVoidableBlocks().contains(block)) {
                    this.clearOrDirtBlock(rfNeeded, sx, sy, sz, block, clear);
                } else {
                    int fortune = this.getCardType() == 4 || this.getCardType() == 7 ? 3 : 0;
                    List drops = block.getDrops((IBlockAccess)this.field_145850_b, srcPos, srcState, fortune);
                    ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)srcState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                    if (this.checkAndInsertItems(block, drops)) {
                        this.clearOrDirtBlock(rfNeeded, sx, sy, sz, block, clear);
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean voidBlock(int rfNeeded, BlockPos srcPos, Block block) {
        IBlockState srcState = this.field_145850_b.func_180495_p(srcPos);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return false;
        }
        if (block.func_176195_g(srcState, this.field_145850_b, srcPos) >= 0.0f) {
            if (!this.silent) {
                SoundTools.playSound((World)this.field_145850_b, (SoundEvent)block.func_185467_w().field_185862_o, (double)sx, (double)sy, (double)sz, (double)1.0, (double)1.0);
            }
            this.field_145850_b.func_175698_g(srcPos);
            this.consumeEnergy(rfNeeded);
        }
        return false;
    }

    private void handleBlock(World world) {
        BlockPos srcPos = this.scan;
        BlockPos destPos = this.sourceToDest(this.scan);
        int x = this.scan.func_177958_n();
        int y = this.scan.func_177956_o();
        int z = this.scan.func_177952_p();
        int destX = destPos.func_177958_n();
        int destY = destPos.func_177956_o();
        int destZ = destPos.func_177952_p();
        switch (this.mode) {
            case 0: {
                this.copyBlock(world, srcPos, this.field_145850_b, destPos);
                break;
            }
            case 1: {
                if (this.entityMode) {
                    this.moveEntities(world, x, y, z, this.field_145850_b, destX, destY, destZ);
                }
                this.moveBlock(world, srcPos, this.field_145850_b, destPos, this.rotate);
                break;
            }
            case 3: {
                if (this.entityMode) {
                    this.moveEntities(this.field_145850_b, destX, destY, destZ, world, x, y, z);
                }
                this.moveBlock(this.field_145850_b, destPos, world, srcPos, this.oppositeRotate());
                break;
            }
            case 2: {
                if (this.entityMode) {
                    this.swapEntities(world, x, y, z, this.field_145850_b, destX, destY, destZ);
                }
                this.swapBlock(world, srcPos, this.field_145850_b, destPos);
            }
        }
        this.nextLocation();
    }

    private IBlockState findAndConsumeBlock(IItemHandler inventory, IBlockState state) {
        if (state == null) {
            ItemStack stack;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                stack = inventory.getStackInSlot(i);
                if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                slots.add(i);
            }
            if (slots.isEmpty()) {
                return null;
            }
            int randomSlot = (Integer)slots.get(random.nextInt(slots.size()));
            stack = inventory.getStackInSlot(randomSlot);
            ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
            inventory.extractItem(randomSlot, 1, false);
            return itemBlock.func_179223_d().func_176203_a(stack.func_77952_i());
        }
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemBlock itemBlock;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemBlock) || (itemBlock = (ItemBlock)stack.func_77973_b()).func_179223_d() != block || stack.func_77952_i() != meta) continue;
            inventory.extractItem(i, 1, false);
            return itemBlock.func_179223_d().func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    private IBlockState findAndConsumeBlock(IInventory inventory, IBlockState state) {
        if (state == null) {
            ItemStack stack;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                stack = inventory.func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                slots.add(i);
            }
            if (slots.isEmpty()) {
                return null;
            }
            int randomSlot = (Integer)slots.get(random.nextInt(slots.size()));
            stack = inventory.func_70301_a(randomSlot);
            ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
            inventory.func_70298_a(randomSlot, 1);
            return itemBlock.func_179223_d().func_176203_a(stack.func_77952_i());
        }
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemBlock itemBlock;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemBlock) || (itemBlock = (ItemBlock)stack.func_77973_b()).func_179223_d() != block || stack.func_77952_i() != meta) continue;
            inventory.func_70298_a(i, 1);
            return itemBlock.func_179223_d().func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    private boolean checkValidItems(Block block, List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (stack.func_77973_b() != null) continue;
            Logging.logError((String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!"));
            Broadcaster.broadcast((World)this.field_145850_b, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!\nPlease report to mod author!"), (float)10.0f);
            return false;
        }
        return true;
    }

    private boolean checkAndInsertItems(Block block, List<ItemStack> items) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
        if (!this.checkValidItems(block, items)) {
            return false;
        }
        boolean ok = InventoryHelper.insertItemsAtomic(items, (TileEntity)te, (EnumFacing)EnumFacing.DOWN);
        if (!ok) {
            te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            ok = InventoryHelper.insertItemsAtomic(items, (TileEntity)te, (EnumFacing)EnumFacing.UP);
        }
        return ok;
    }

    private ItemStack insertItem(ItemStack s) {
        s = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.UP, (ItemStack)s);
        if (s != null) {
            s = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.DOWN, (ItemStack)s);
        }
        return s;
    }

    private IBlockState consumeBlock(EnumFacing direction, IBlockState state) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (te != null) {
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) {
                IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
                return this.findAndConsumeBlock(capability, state);
            }
            if (te instanceof IInventory) {
                return this.findAndConsumeBlock((IInventory)te, state);
            }
        }
        return null;
    }

    private IBlockState consumeBlock(IBlockState state) {
        IBlockState b = this.consumeBlock(EnumFacing.UP, state);
        if (b == null) {
            b = this.consumeBlock(EnumFacing.UP, state);
        }
        return b;
    }

    public static BuilderSetup.BlockInformation getBlockInformation(World world, BlockPos pos, Block block, TileEntity tileEntity) {
        IBlockState state = world.func_180495_p(pos);
        if (BuilderTileEntity.isEmpty(state, block)) {
            return BuilderSetup.BlockInformation.FREE;
        }
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)DimensionManager.getWorld((int)0));
        if (!block.canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)fakePlayer)) {
            return BuilderSetup.BlockInformation.INVALID;
        }
        BuilderSetup.BlockInformation blockInformation = BuilderSetup.getBlockInformation(block);
        if (tileEntity != null) {
            switch (BuilderConfiguration.teMode) {
                case MOVE_FORBIDDEN: {
                    return BuilderSetup.BlockInformation.INVALID;
                }
                case MOVE_WHITELIST: {
                    if (blockInformation != null && blockInformation.getBlockLevel() != 2) break;
                    return BuilderSetup.BlockInformation.INVALID;
                }
                case MOVE_BLACKLIST: {
                    if (blockInformation == null || blockInformation.getBlockLevel() != 2) break;
                    return BuilderSetup.BlockInformation.INVALID;
                }
            }
        }
        if (blockInformation != null) {
            return blockInformation;
        }
        return BuilderSetup.BlockInformation.OK;
    }

    private int isMovable(World world, BlockPos pos, Block block, TileEntity tileEntity) {
        return BuilderTileEntity.getBlockInformation(world, pos, block, tileEntity).getBlockLevel();
    }

    public static boolean isEmptyOrReplacable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            return true;
        }
        return BuilderTileEntity.isEmpty(state, block);
    }

    public static boolean isEmpty(IBlockState state, Block block) {
        if (block == null) {
            return true;
        }
        if (block.func_149688_o(state) == Material.field_151579_a) {
            return true;
        }
        return block == BuilderSetup.supportBlock;
    }

    private void clearBlock(World world, BlockPos pos) {
        if (this.supportMode) {
            world.func_180501_a(pos, BuilderSetup.supportBlock.func_176223_P(), 3);
        } else {
            world.func_175698_g(pos);
        }
    }

    private int oppositeRotate() {
        switch (this.rotate) {
            case 1: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return this.rotate;
    }

    private int rotateMeta(Block block, int meta, BuilderSetup.BlockInformation information, int rotMode) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            return meta;
        }
        switch (information.getRotateInfo()) {
            case 1: {
                break;
            }
            case 0: {
                return meta;
            }
        }
        return meta;
    }

    private void copyBlock(World world, BlockPos srcPos, World destWorld, BlockPos destPos) {
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if (rfNeeded > rf) {
            return;
        }
        if (BuilderTileEntity.isEmptyOrReplacable(destWorld, destPos)) {
            if (world.func_175623_d(srcPos)) {
                return;
            }
            IBlockState state = world.func_180495_p(srcPos);
            if (this.consumeBlock(state) == null) {
                return;
            }
            Block origBlock = state.func_177230_c();
            int origMeta = origBlock.func_176201_c(state);
            BuilderSetup.BlockInformation information = BuilderTileEntity.getBlockInformation(world, srcPos, origBlock, null);
            origMeta = this.rotateMeta(origBlock, origMeta, information, this.rotate);
            destWorld.func_180501_a(destPos, origBlock.func_176203_a(origMeta), 3);
            if (!this.silent) {
                SoundTools.playSound((World)destWorld, (SoundEvent)origBlock.func_185467_w().field_185862_o, (double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)1.0, (double)1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
    }

    private double getDimensionCostFactor(World world, World destWorld) {
        return destWorld.field_73011_w.getDimension() == world.field_73011_w.getDimension() ? 1.0 : BuilderConfiguration.dimensionCostFactor;
    }

    private boolean consumeEntityEnergy(int rfNeeded, int rfNeededPlayer, Entity entity) {
        int rf;
        int rfn = entity instanceof EntityPlayer ? rfNeededPlayer : rfNeeded;
        if (rfn > (rf = this.getEnergyStored(EnumFacing.DOWN))) {
            return true;
        }
        this.consumeEnergy(rfn);
        return false;
    }

    private void moveEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerEntity * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)BuilderConfiguration.builderRfPerPlayer * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)x - 0.1, (double)y - 0.1, (double)z - 0.1, (double)x + 1.1, (double)y + 1.1, (double)z + 1.1));
        for (Object o : entities) {
            Entity entity = (Entity)o;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            double newX = (double)destX + (entity.field_70165_t - (double)x);
            double newY = (double)destY + (entity.field_70163_u - (double)y);
            double newZ = (double)destZ + (entity.field_70161_v - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
    }

    private void swapEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        double newZ;
        double newY;
        double newX;
        Entity entity;
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerEntity * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)BuilderConfiguration.builderRfPerPlayer * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entitiesSrc = world.func_72839_b(null, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        List entitiesDst = destWorld.func_72839_b(null, new AxisAlignedBB((double)destX, (double)destY, (double)destZ, (double)(destX + 1), (double)(destY + 1), (double)(destZ + 1)));
        for (Object o : entitiesSrc) {
            entity = (Entity)o;
            if (!this.isEntityInBlock(x, y, z, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)destX + (entity.field_70165_t - (double)x);
            newY = (double)destY + (entity.field_70163_u - (double)y);
            newZ = (double)destZ + (entity.field_70161_v - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
        for (Object o : entitiesDst) {
            entity = (Entity)o;
            if (!this.isEntityInBlock(destX, destY, destZ, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)x + (entity.field_70165_t - (double)destX);
            newY = (double)y + (entity.field_70163_u - (double)destY);
            newZ = (double)z + (entity.field_70161_v - (double)destZ);
            this.teleportEntity(destWorld, world, entity, newX, newY, newZ);
        }
    }

    private void teleportEntity(World world, World destWorld, Entity entity, double newX, double newY, double newZ) {
        if (!TeleportationTools.allowTeleport(entity, world.field_73011_w.getDimension(), entity.func_180425_c(), destWorld.field_73011_w.getDimension(), new BlockPos(newX, newY, newZ))) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            if (world.field_73011_w.getDimension() != destWorld.field_73011_w.getDimension()) {
                TeleportationTools.teleportToDimension((EntityPlayer)entity, destWorld.field_73011_w.getDimension(), newX, newY, newZ);
            }
            entity.func_70634_a(newX, newY, newZ);
        } else if (world.field_73011_w.getDimension() != destWorld.field_73011_w.getDimension()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            float rotationYaw = entity.field_70177_z;
            float rotationPitch = entity.field_70125_A;
            entity.func_189511_e(tagCompound);
            Class<?> entityClass = entity.getClass();
            world.func_72900_e(entity);
            try {
                Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(destWorld);
                newEntity.func_70020_e(tagCompound);
                newEntity.func_70012_b(newX, newY, newZ, rotationYaw, rotationPitch);
                destWorld.func_72838_d(newEntity);
            }
            catch (Exception exception) {}
        } else {
            entity.func_70012_b(newX, newY, newZ, entity.field_70177_z, entity.field_70125_A);
            destWorld.func_72866_a(entity, false);
        }
    }

    private boolean isEntityInBlock(int x, int y, int z, Entity entity) {
        return entity.field_70165_t >= (double)x && entity.field_70165_t < (double)(x + 1) && entity.field_70163_u >= (double)y && entity.field_70163_u < (double)(y + 1) && entity.field_70161_v >= (double)z && entity.field_70161_v < (double)(z + 1);
    }

    private void moveBlock(World world, BlockPos srcPos, World destWorld, BlockPos destPos, int rotMode) {
        Block destBlock;
        IBlockState destState = destWorld.func_180495_p(destPos);
        if (BuilderTileEntity.isEmpty(destState, destBlock = destState.func_177230_c())) {
            Block origBlock;
            IBlockState state = world.func_180495_p(srcPos);
            if (BuilderTileEntity.isEmpty(state, origBlock = state.func_177230_c())) {
                return;
            }
            TileEntity origTileEntity = world.func_175625_s(srcPos);
            BuilderSetup.BlockInformation information = BuilderTileEntity.getBlockInformation(world, srcPos, origBlock, origTileEntity);
            if (information.getBlockLevel() == 2) {
                return;
            }
            int rf = this.getEnergyStored(EnumFacing.DOWN);
            int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * information.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
            if (rfNeeded > rf) {
                return;
            }
            this.consumeEnergy(rfNeeded);
            int origMeta = origBlock.func_176201_c(state);
            origMeta = this.rotateMeta(origBlock, origMeta, information, rotMode);
            world.func_175713_t(srcPos);
            this.clearBlock(world, srcPos);
            BlockPos destpos = destPos;
            IBlockState newDestState = origBlock.func_176203_a(origMeta);
            destWorld.func_180501_a(destpos, newDestState, 3);
            if (origTileEntity != null) {
                origTileEntity.func_145829_t();
                destWorld.func_175690_a(destpos, origTileEntity);
                origTileEntity.func_70296_d();
                destWorld.func_184138_a(destpos, newDestState, newDestState, 3);
            }
            if (!this.silent) {
                SoundTools.playSound((World)world, (SoundEvent)origBlock.func_185467_w().field_185862_o, (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)destWorld, (SoundEvent)origBlock.func_185467_w().field_185862_o, (double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)1.0, (double)1.0);
            }
        }
    }

    private void swapBlock(World world, BlockPos srcPos, World destWorld, BlockPos dstPos) {
        IBlockState srcState = world.func_180495_p(srcPos);
        Block srcBlock = srcState.func_177230_c();
        TileEntity srcTileEntity = world.func_175625_s(srcPos);
        IBlockState dstState = destWorld.func_180495_p(dstPos);
        Block dstBlock = dstState.func_177230_c();
        TileEntity dstTileEntity = destWorld.func_175625_s(dstPos);
        if (BuilderTileEntity.isEmpty(srcState, srcBlock) && BuilderTileEntity.isEmpty(dstState, dstBlock)) {
            return;
        }
        BuilderSetup.BlockInformation srcInformation = BuilderTileEntity.getBlockInformation(world, srcPos, srcBlock, srcTileEntity);
        if (srcInformation.getBlockLevel() == 2) {
            return;
        }
        BuilderSetup.BlockInformation dstInformation = BuilderTileEntity.getBlockInformation(destWorld, dstPos, dstBlock, dstTileEntity);
        if (dstInformation.getBlockLevel() == 2) {
            return;
        }
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if ((rfNeeded += (int)((double)BuilderConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * dstInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0)) > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        int srcMeta = srcBlock.func_176201_c(srcState);
        srcMeta = this.rotateMeta(srcBlock, srcMeta, srcInformation, this.oppositeRotate());
        int dstMeta = dstBlock.func_176201_c(dstState);
        dstMeta = this.rotateMeta(dstBlock, dstMeta, dstInformation, this.rotate);
        world.func_175713_t(srcPos);
        world.func_175698_g(srcPos);
        destWorld.func_175713_t(dstPos);
        destWorld.func_175698_g(dstPos);
        IBlockState newDstState = srcBlock.func_176203_a(srcMeta);
        destWorld.func_180501_a(dstPos, newDstState, 3);
        if (srcTileEntity != null) {
            srcTileEntity.func_145829_t();
            destWorld.func_175690_a(dstPos, srcTileEntity);
            srcTileEntity.func_70296_d();
            destWorld.func_184138_a(dstPos, newDstState, newDstState, 3);
        }
        IBlockState newSrcState = dstBlock.func_176203_a(dstMeta);
        world.func_180501_a(srcPos, newSrcState, 3);
        if (dstTileEntity != null) {
            dstTileEntity.func_145829_t();
            world.func_175690_a(srcPos, dstTileEntity);
            dstTileEntity.func_70296_d();
            world.func_184138_a(srcPos, newSrcState, newSrcState, 3);
        }
        if (!this.silent) {
            if (!BuilderTileEntity.isEmpty(srcState, srcBlock)) {
                SoundTools.playSound((World)world, (SoundEvent)srcBlock.func_185467_w().field_185862_o, (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
            }
            if (!BuilderTileEntity.isEmpty(dstState, dstBlock)) {
                SoundTools.playSound((World)destWorld, (SoundEvent)dstBlock.func_185467_w().field_185862_o, (double)dstPos.func_177958_n(), (double)dstPos.func_177956_o(), (double)dstPos.func_177952_p(), (double)1.0, (double)1.0);
            }
        }
    }

    private BlockPos sourceToDest(BlockPos source) {
        return this.rotate(source).func_177982_a(this.projDx, this.projDy, this.projDz);
    }

    private void restartScan() {
        this.chunkUnload();
        if (this.loopMode || this.powerLevel > 0 && this.scan == null) {
            if (this.getCardType() == -1) {
                this.calculateBox();
                this.scan = this.minBox;
            } else if (this.getCardType() != -2) {
                this.calculateBoxShaped();
                this.scan = new BlockPos(this.minBox.func_177958_n(), this.maxBox.func_177956_o(), this.minBox.func_177952_p());
            }
            this.cachedBlocks = null;
            this.cachedChunk = null;
            this.cachedVoidableBlocks = null;
        } else {
            this.scan = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chunkUnload();
    }

    private void chunkUnload() {
        if (this.forcedChunk != null && this.ticket != null) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            this.forcedChunk = null;
        }
    }

    private boolean chunkLoad(int x, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        if (RFToolsTools.chunkLoaded(this.field_145850_b, new BlockPos(x, 0, z))) {
            return true;
        }
        if (BuilderConfiguration.quarryChunkloads) {
            ChunkPos pair;
            if (this.ticket == null) {
                ForgeChunkManager.setForcedChunkLoadingCallback((Object)RFTools.instance, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.LoadingCallback(){

                    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
                    }
                });
                this.ticket = ForgeChunkManager.requestTicket((Object)RFTools.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket == null) {
                    return false;
                }
            }
            if ((pair = new ChunkPos(cx, cz)).equals((Object)this.forcedChunk)) {
                return true;
            }
            if (this.forcedChunk != null) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            }
            this.forcedChunk = pair;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            return true;
        }
        return false;
    }

    private void nextLocation() {
        if (this.scan != null) {
            int x = this.scan.func_177958_n();
            int y = this.scan.func_177956_o();
            int z = this.scan.func_177952_p();
            if (this.getCardType() == -1) {
                this.nextLocationNormal(x, y, z);
            } else {
                this.nextLocationQuarry(x, y, z);
            }
        }
    }

    private void nextLocationQuarry(int x, int y, int z) {
        if (x >= this.maxBox.func_177958_n() || (x + 1) % 16 == 0) {
            if (z >= this.maxBox.func_177952_p() || (z + 1) % 16 == 0) {
                if (y <= this.minBox.func_177956_o()) {
                    if (x < this.maxBox.func_177958_n()) {
                        z = z >> 4 << 4;
                        y = this.maxBox.func_177956_o();
                        this.scan = new BlockPos(++x, y, z);
                    } else if (z < this.maxBox.func_177952_p()) {
                        x = this.minBox.func_177958_n();
                        y = this.maxBox.func_177956_o();
                        this.scan = new BlockPos(x, y, ++z);
                    } else {
                        this.restartScan();
                    }
                } else {
                    this.scan = new BlockPos(x >> 4 << 4, y - 1, z >> 4 << 4);
                }
            } else {
                this.scan = new BlockPos(x >> 4 << 4, y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void nextLocationNormal(int x, int y, int z) {
        if (x >= this.maxBox.func_177958_n()) {
            if (z >= this.maxBox.func_177952_p()) {
                if (y >= this.maxBox.func_177956_o()) {
                    if (this.mode != 2 || this.isShapeCard()) {
                        this.restartScan();
                    } else {
                        this.scan = null;
                    }
                } else {
                    this.scan = new BlockPos(this.minBox.func_177958_n(), y + 1, this.minBox.func_177952_p());
                }
            } else {
                this.scan = new BlockPos(this.minBox.func_177958_n(), y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return BuilderContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return BuilderContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return BuilderContainer.factory.isOutputSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index == 0 && this.inventoryHelper.getStackInSlot(index) != null && amount > 0) {
            this.refreshSettings();
        }
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0 && (stack == null && this.inventoryHelper.getStackInSlot(index) != null || stack != null && this.inventoryHelper.getStackInSlot(index) == null)) {
            this.refreshSettings();
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    private void refreshSettings() {
        this.clearSupportBlocks();
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks = null;
        this.boxValid = false;
        this.scan = null;
        this.cardType = -2;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == BuilderSetup.spaceChamberCardItem || stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.mode = tagCompound.func_74762_e("mode");
        this.anchor = tagCompound.func_74762_e("anchor");
        this.rotate = tagCompound.func_74762_e("rotate");
        this.silent = tagCompound.func_74767_n("silent");
        this.supportMode = tagCompound.func_74767_n("support");
        this.entityMode = tagCompound.func_74767_n("entityMode");
        this.loopMode = tagCompound.func_74767_n("loopMode");
        this.scan = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"scan");
        this.minBox = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"minBox");
        this.maxBox = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"maxBox");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("mode", this.mode);
        tagCompound.func_74768_a("anchor", this.anchor);
        tagCompound.func_74768_a("rotate", this.rotate);
        tagCompound.func_74757_a("silent", this.silent);
        tagCompound.func_74757_a("support", this.supportMode);
        tagCompound.func_74757_a("entityMode", this.entityMode);
        tagCompound.func_74757_a("loopMode", this.loopMode);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"maxBox", (BlockPos)this.maxBox);
    }

    public void requestCurrentLevel() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftools", this.func_174877_v(), "getLevel", "getLevel", new Argument[0]));
    }

    public static int getCurrentLevel() {
        return currentLevel;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode(args.get("mode").getInteger());
            return true;
        }
        if (CMD_SETANCHOR.equals(command)) {
            this.setAnchor(args.get("anchor").getInteger());
            return true;
        }
        if (CMD_SETROTATE.equals(command)) {
            this.setRotate(args.get("rotate").getInteger());
            return true;
        }
        if (CMD_SETSILENT.equals(command)) {
            this.setSilent(args.get("silent").getBoolean());
            return true;
        }
        if (CMD_SETSUPPORT.equals(command)) {
            this.setSupportMode(args.get("support").getBoolean());
            return true;
        }
        if (CMD_SETENTITIES.equals(command)) {
            this.setEntityMode(args.get("entities").getBoolean());
            return true;
        }
        if (CMD_SETLOOP.equals(command)) {
            this.setLoopMode(args.get("loop").getBoolean());
            return true;
        }
        return false;
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getLevel".equals(command)) {
            return this.scan == null ? -1 : this.scan.func_177956_o();
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getLevel".equals(command)) {
            currentLevel = result;
            return true;
        }
        return false;
    }
}

