/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEndergenicFlash
implements IMessage {
    private BlockPos pos;
    private int goodCounter;
    private int badCounter;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.goodCounter = buf.readInt();
        this.badCounter = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.goodCounter);
        buf.writeInt(this.badCounter);
    }

    public PacketEndergenicFlash() {
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public PacketEndergenicFlash(BlockPos pos, int goodCounter, int badCounter) {
        this.pos = pos;
        this.goodCounter = goodCounter;
        this.badCounter = badCounter;
    }

    public static class Handler
    implements IMessageHandler<PacketEndergenicFlash, IMessage> {
        public IMessage onMessage(PacketEndergenicFlash message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> Handler.handle(message));
            return null;
        }

        private static void handle(PacketEndergenicFlash message) {
            TileEntity te = RFTools.proxy.getClientWorld().func_175625_s(message.getPos());
            if (te instanceof EndergenicTileEntity) {
                EndergenicTileEntity tileEntity = (EndergenicTileEntity)te;
                tileEntity.syncCountersFromServer(message.goodCounter, message.badCounter);
            }
        }
    }
}

