/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sensor;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.sensor.AreaType;
import mcjty.rftools.blocks.logic.sensor.GroupType;
import mcjty.rftools.blocks.logic.sensor.SensorContainer;
import mcjty.rftools.blocks.logic.sensor.SensorTileEntity;
import mcjty.rftools.blocks.logic.sensor.SensorType;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.varia.NamedEnum;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiSensor
extends GenericGuiContainer<SensorTileEntity> {
    public static final int SENSOR_WIDTH = 180;
    public static final int SENSOR_HEIGHT = 152;
    public static final String OREDICT_USE = "Use";
    public static final String OREDICT_IGNORE = "Ignore";
    public static final String META_MATCH = "Match";
    public static final String META_IGNORE = "Ignore";
    private TextField numberField;
    private ChoiceLabel typeLabel;
    private ChoiceLabel areaLabel;
    private ChoiceLabel groupLabel;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/sensor.png");

    public GuiSensor(SensorTileEntity sensorTileEntity, SensorContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)sensorTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "sensor");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        this.numberField = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Set a number specific to the type of sensor"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 51, 80, 14))).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiSensor.this.setNumber();
            }
        });
        int number = ((SensorTileEntity)this.tileEntity).getNumber();
        this.numberField.setText(String.valueOf(number));
        this.typeLabel = new ChoiceLabel(this.field_146297_k, (Gui)this);
        for (SensorType sensorType : SensorType.values()) {
            this.typeLabel.addChoices(new String[]{sensorType.getName()});
            this.typeLabel.setChoiceTooltip(sensorType.getName(), sensorType.getDescription());
        }
        this.typeLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 3, 80, 14));
        this.typeLabel.setChoice(((SensorTileEntity)this.tileEntity).getSensorType().getName());
        this.typeLabel.addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiSensor.this.setType();
            }
        });
        this.areaLabel = new ChoiceLabel(this.field_146297_k, (Gui)this);
        for (Enum enum_ : AreaType.values()) {
            this.areaLabel.addChoices(new String[]{((AreaType)enum_).getName()});
            this.areaLabel.setChoiceTooltip(((AreaType)enum_).getName(), ((AreaType)enum_).getDescription());
        }
        this.areaLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 19, 80, 14));
        this.areaLabel.setChoice(((SensorTileEntity)this.tileEntity).getAreaType().getName());
        this.areaLabel.addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiSensor.this.setArea();
            }
        });
        this.groupLabel = new ChoiceLabel(this.field_146297_k, (Gui)this);
        for (Enum enum_ : GroupType.values()) {
            this.groupLabel.addChoices(new String[]{((GroupType)enum_).getName()});
            this.groupLabel.setChoiceTooltip(((GroupType)enum_).getName(), ((GroupType)enum_).getDescription());
        }
        this.groupLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 35, 80, 14));
        this.groupLabel.setChoice(((SensorTileEntity)this.tileEntity).getGroupType().getName());
        this.groupLabel.addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiSensor.this.setGroup();
            }
        });
        ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Type:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 3, 50, 14)))).addChild((Widget)this.areaLabel)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Area:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 19, 50, 14)))).addChild((Widget)this.typeLabel)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Group:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 35, 50, 14)))).addChild((Widget)this.groupLabel)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Number:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 51, 50, 14)))).addChild((Widget)this.numberField);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setArea() {
        AreaType areaType = (AreaType)NamedEnum.getEnumByName((String)this.areaLabel.getCurrentChoice(), (NamedEnum[])AreaType.values());
        ((SensorTileEntity)this.tileEntity).setAreaType(areaType);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setArea", new Argument[]{new Argument("type", areaType.ordinal())});
    }

    private void setType() {
        SensorType sensorType = this.getSensorType();
        ((SensorTileEntity)this.tileEntity).setSensorType(sensorType);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setType", new Argument[]{new Argument("type", sensorType.ordinal())});
    }

    private SensorType getSensorType() {
        return (SensorType)NamedEnum.getEnumByName((String)this.typeLabel.getCurrentChoice(), (NamedEnum[])SensorType.values());
    }

    private void setGroup() {
        GroupType groupType = (GroupType)NamedEnum.getEnumByName((String)this.groupLabel.getCurrentChoice(), (NamedEnum[])GroupType.values());
        ((SensorTileEntity)this.tileEntity).setGroupType(groupType);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setGroup", new Argument[]{new Argument("type", groupType.ordinal())});
    }

    private void setNumber() {
        int number;
        String d = this.numberField.getText();
        try {
            number = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            number = 1;
        }
        ((SensorTileEntity)this.tileEntity).setNumber(number);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setNumber", new Argument[]{new Argument("number", number)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        SensorType sensorType = this.getSensorType();
        this.numberField.setEnabled(sensorType.isSupportsNumber());
        this.groupLabel.setEnabled(sensorType.isSupportsGroup());
        this.drawWindow();
    }
}

