/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sensor;

import java.util.List;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import mcjty.rftools.blocks.logic.sensor.AreaType;
import mcjty.rftools.blocks.logic.sensor.GroupType;
import mcjty.rftools.blocks.logic.sensor.SensorContainer;
import mcjty.rftools.blocks.logic.sensor.SensorType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class SensorTileEntity
extends LogicTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SETNUMBER = "setNumber";
    public static final String CMD_SETTYPE = "setType";
    public static final String CMD_SETAREA = "setArea";
    public static final String CMD_SETGROUP = "setGroup";
    private int number = 0;
    private SensorType sensorType = SensorType.SENSOR_BLOCK;
    private AreaType areaType = AreaType.AREA_1;
    private GroupType groupType = GroupType.GROUP_ONE;
    private int checkCounter = 0;
    private AxisAlignedBB cachedBox = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, SensorContainer.factory, 1);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        this.cachedBox = null;
        this.func_70296_d();
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
        this.cachedBox = null;
        this.func_70296_d();
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
        this.cachedBox = null;
        this.func_70296_d();
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
        this.cachedBox = null;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.setRedstoneState(this.checkSensor());
    }

    public boolean checkSensor() {
        boolean newout;
        EnumFacing inputSide = this.getFacing(this.field_145850_b.func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos newpos = this.func_174877_v().func_177972_a(inputSide);
        switch (this.sensorType) {
            case SENSOR_BLOCK: {
                newout = this.checkBlock(newpos, inputSide);
                break;
            }
            case SENSOR_GROWTHLEVEL: {
                newout = this.checkGrowthLevel(newpos, inputSide);
                break;
            }
            case SENSOR_ENTITIES: {
                newout = this.checkEntities(newpos, inputSide, Entity.class);
                break;
            }
            case SENSOR_PLAYERS: {
                newout = this.checkEntities(newpos, inputSide, EntityPlayer.class);
                break;
            }
            case SENSOR_HOSTILE: {
                newout = this.checkEntitiesHostile(newpos, inputSide);
                break;
            }
            case SENSOR_PASSIVE: {
                newout = this.checkEntitiesPassive(newpos, inputSide);
                break;
            }
            default: {
                newout = false;
            }
        }
        return newout;
    }

    private boolean checkBlock(BlockPos newpos, EnumFacing dir) {
        int blockCount = this.areaType.getBlockCount();
        for (int i = 0; i < blockCount; ++i) {
            boolean result = this.checkBlock(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.func_177972_a(dir);
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private boolean checkBlock(BlockPos newpos) {
        IBlockState state = this.field_145850_b.func_180495_p(newpos);
        ItemStack matcher = this.inventoryHelper.getStackInSlot(0);
        if (matcher == null) {
            return state.func_177230_c().func_149730_j(state);
        }
        ItemStack stack = state.func_177230_c().func_185473_a(this.field_145850_b, newpos, state);
        if (stack != null) {
            return matcher.func_77973_b() == stack.func_77973_b();
        }
        return matcher.func_77973_b() == Item.func_150898_a((Block)state.func_177230_c());
    }

    private boolean checkGrowthLevel(BlockPos newpos, EnumFacing dir) {
        int blockCount = this.areaType.getBlockCount();
        for (int i = 0; i < blockCount; ++i) {
            boolean result = this.checkGrowthLevel(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.func_177972_a(dir);
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private boolean checkGrowthLevel(BlockPos newpos) {
        int pct;
        IBlockState state = this.field_145850_b.func_180495_p(newpos);
        Block block = state.func_177230_c();
        if (block instanceof BlockCrops) {
            BlockCrops crops = (BlockCrops)block;
            int age = crops.func_185527_x(state);
            int maxAge = crops.func_185526_g();
            pct = age * 100 / maxAge;
        } else if (block instanceof BlockNetherWart) {
            BlockNetherWart wart = (BlockNetherWart)block;
            int age = (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
            int maxAge = 3;
            pct = age * 100 / maxAge;
        } else {
            pct = 0;
        }
        return pct >= this.number;
    }

    private AxisAlignedBB getCachedBox(BlockPos pos1, EnumFacing dir) {
        if (this.cachedBox == null) {
            int n = this.areaType.getBlockCount();
            this.cachedBox = new AxisAlignedBB(pos1);
            if (n > 1) {
                BlockPos pos2 = pos1.func_177967_a(dir, n - 1);
                this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
            }
            this.cachedBox = this.cachedBox.func_72314_b(0.1, 0.1, 0.1);
        }
        return this.cachedBox;
    }

    private boolean checkEntities(BlockPos pos1, EnumFacing dir, Class<? extends Entity> clazz) {
        List entities = this.field_145850_b.func_72872_a(clazz, this.getCachedBox(pos1, dir));
        return entities.size() >= this.number;
    }

    private boolean checkEntitiesHostile(BlockPos pos1, EnumFacing dir) {
        List entities = this.field_145850_b.func_72872_a(EntityCreature.class, this.getCachedBox(pos1, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof IMob) || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntitiesPassive(BlockPos pos1, EnumFacing dir) {
        List entities = this.field_145850_b.func_72872_a(EntityCreature.class, this.getCachedBox(pos1, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof IAnimals) || entity instanceof IMob || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74767_n("rs");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.number = tagCompound.func_74762_e("number");
        this.sensorType = SensorType.values()[tagCompound.func_74771_c("sensor")];
        this.areaType = AreaType.values()[tagCompound.func_74771_c("area")];
        this.groupType = GroupType.values()[tagCompound.func_74771_c("group")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powered);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("number", this.number);
        tagCompound.func_74774_a("sensor", (byte)this.sensorType.ordinal());
        tagCompound.func_74774_a("area", (byte)this.areaType.ordinal());
        tagCompound.func_74774_a("group", (byte)this.groupType.ordinal());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETNUMBER.equals(command)) {
            this.setNumber(args.get("number").getInteger());
            return true;
        }
        if (CMD_SETAREA.equals(command)) {
            this.setAreaType(AreaType.values()[args.get("type").getInteger()]);
            return true;
        }
        if (CMD_SETTYPE.equals(command)) {
            this.setSensorType(SensorType.values()[args.get("type").getInteger()]);
            return true;
        }
        if (CMD_SETGROUP.equals(command)) {
            this.setGroupType(GroupType.values()[args.get("type").getInteger()]);
            return true;
        }
        return false;
    }
}

