/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.monitor.LiquidMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.RFMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketContentsMonitor
implements IMessage {
    private BlockPos pos;
    private BlockPos monitor = null;
    private int alarmLevel = -1;
    private RFMonitorMode alarmMode = RFMonitorMode.MODE_OFF;

    public PacketContentsMonitor() {
    }

    public PacketContentsMonitor(BlockPos pos, BlockPos monitor) {
        this();
        this.pos = pos;
        this.monitor = monitor;
    }

    public PacketContentsMonitor(BlockPos pos, RFMonitorMode alarmMode, int alarmLevel) {
        this();
        this.pos = pos;
        this.alarmLevel = alarmLevel;
        this.alarmMode = alarmMode;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        boolean r = buf.readBoolean();
        if (r) {
            this.monitor = NetworkTools.readPos((ByteBuf)buf);
        }
        this.alarmLevel = buf.readByte();
        this.alarmMode = RFMonitorMode.getModeFromIndex(buf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        if (this.monitor == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.monitor);
        }
        buf.writeByte(this.alarmLevel);
        buf.writeByte(this.alarmMode.getIndex());
    }

    public static class Handler
    implements IMessageHandler<PacketContentsMonitor, IMessage> {
        public IMessage onMessage(PacketContentsMonitor message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketContentsMonitor message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
            if (te instanceof RFMonitorBlockTileEntity) {
                RFMonitorBlockTileEntity monitorBlockTileEntity = (RFMonitorBlockTileEntity)te;
                if (message.monitor != null) {
                    monitorBlockTileEntity.setMonitor(message.monitor);
                }
                if (message.alarmLevel != -1) {
                    monitorBlockTileEntity.setAlarm(message.alarmMode, message.alarmLevel);
                }
            } else if (te instanceof LiquidMonitorBlockTileEntity) {
                LiquidMonitorBlockTileEntity liquidMonitorBlockTileEntity = (LiquidMonitorBlockTileEntity)te;
                if (message.monitor != null) {
                    liquidMonitorBlockTileEntity.setMonitor(message.monitor);
                }
                if (message.alarmLevel != -1) {
                    liquidMonitorBlockTileEntity.setAlarm(message.alarmMode, message.alarmLevel);
                }
            } else {
                Logging.log((String)"TileEntity is not a RFMonitorBlockTileEntity!");
            }
        }
    }
}

