/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBarScreenModule
implements IScreenModule<IModuleDataContents> {
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();

    @Override
    public IModuleDataContents getData(IScreenDataHelper h, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!RFToolsTools.chunkLoaded((World)world, this.coordinate)) {
            return null;
        }
        int contents = 0;
        int maxContents = 0;
        TileEntity te = world.func_175625_s(this.coordinate);
        if (RFToolsTools.hasFluidCapabilitySafe(te)) {
            IFluidHandler handler = RFToolsTools.getFluidCapabilitySafe(te);
            IFluidTankProperties[] properties = handler.getTankProperties();
            if (properties != null && properties.length > 0) {
                if (properties[0].getContents() != null) {
                    contents = properties[0].getContents().amount;
                }
                maxContents = properties[0].getCapacity();
            }
        } else if (te instanceof net.minecraftforge.fluids.IFluidHandler) {
            net.minecraftforge.fluids.IFluidHandler tank = (net.minecraftforge.fluids.IFluidHandler)te;
            FluidTankInfo[] tankInfo = tank.getTankInfo(EnumFacing.DOWN);
            if (tankInfo != null && tankInfo.length > 0) {
                if (tankInfo[0].fluid != null) {
                    contents = tankInfo[0].fluid.amount;
                }
                maxContents = tankInfo[0].capacity;
            }
        } else {
            return null;
        }
        return this.helper.getContentsValue(millis, contents, maxContents);
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.helper.setShowdiff(tagCompound.func_74767_n("showdiff"));
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.FLUID_RFPERTICK;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

