/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.network.PacketReturnScreenData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class PacketGetScreenData
implements IMessage {
    private String modid;
    private GlobalCoordinate pos;
    private long millis;

    public void fromBytes(ByteBuf buf) {
        this.modid = NetworkTools.readString((ByteBuf)buf);
        this.pos = new GlobalCoordinate(NetworkTools.readPos((ByteBuf)buf), buf.readInt());
        this.millis = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.modid);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos.getCoordinate());
        buf.writeInt(this.pos.getDimension());
        buf.writeLong(this.millis);
    }

    public PacketGetScreenData() {
    }

    public PacketGetScreenData(String modid, GlobalCoordinate pos, long millis) {
        this.modid = modid;
        this.pos = pos;
        this.millis = millis;
    }

    public static class Handler
    implements IMessageHandler<PacketGetScreenData, IMessage> {
        public IMessage onMessage(PacketGetScreenData message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetScreenData message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            if (message.pos.getDimension() != world.field_73011_w.getDimension()) {
                return;
            }
            TileEntity te = world.func_175625_s(message.pos.getCoordinate());
            if (!(te instanceof ScreenTileEntity)) {
                Logging.logError((String)"PacketGetScreenData: TileEntity is not a SimpleScreenTileEntity!");
                return;
            }
            Map<Integer, IModuleData> screenData = ((ScreenTileEntity)te).getScreenData(message.millis);
            SimpleNetworkWrapper wrapper = (SimpleNetworkWrapper)PacketHandler.modNetworking.get(message.modid);
            PacketReturnScreenData msg = new PacketReturnScreenData(message.pos, screenData);
            wrapper.sendTo((IMessage)msg, ctx.getServerHandler().field_147369_b);
        }
    }
}

