/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.security.PacketGetSecurityInfo;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.security.SecurityManagerContainer;
import mcjty.rftools.blocks.security.SecurityManagerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiSecurityManager
extends GenericGuiContainer<SecurityManagerTileEntity> {
    public static final int SECURITYMANAGER_WIDTH = 244;
    public static final int SECURITYMANAGER_HEIGHT = 206;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/securitymanager.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private WidgetList players;
    private Button addButton;
    private Button delButton;
    private TextField nameField;
    private ImageChoiceLabel blacklistMode;
    private TextField channelNameField;
    private int listDirty = 0;
    public static SecurityChannels.SecurityChannel channelFromServer = null;

    public GuiSecurityManager(SecurityManagerTileEntity securityManagerTileEntity, SecurityManagerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)securityManagerTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "security");
        this.field_146999_f = 244;
        this.field_147000_g = 206;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.players = new WidgetList(this.field_146297_k, (Gui)this);
        Slider allowedPlayerSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.players);
        Panel allowedPlayersPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.players)).addChild((Widget)allowedPlayerSlider)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(72, 5, 168, 96));
        this.nameField = (TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(15);
        this.addButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Add")).setDesiredHeight(14)).setDesiredWidth(34)).setTooltips(new String[]{"Add a player to the access list"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiSecurityManager.this.addPlayer();
            }
        });
        this.delButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Del")).setDesiredHeight(14)).setDesiredWidth(34)).setTooltips(new String[]{"Remove the selected player", "from the access list"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiSecurityManager.this.delPlayer();
            }
        });
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.nameField)).addChild((Widget)this.addButton)).addChild((Widget)this.delButton)).setDesiredHeight(16)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(72, 100, 168, 14));
        this.channelNameField = ((TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 27, 60, 14))).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiSecurityManager.this.updateChannelName();
            }
        });
        this.blacklistMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 44, 16, 16))).setTooltips(new String[]{"Black or whitelist mode"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiSecurityManager.this.updateSettings();
            }
        });
        this.blacklistMode.addChoice("White", "Whitelist players", guiElements, 240, 32);
        this.blacklistMode.addChoice("Black", "Blacklist players", guiElements, 224, 32);
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)allowedPlayersPanel)).addChild((Widget)buttonPanel)).addChild((Widget)this.channelNameField)).addChild((Widget)this.blacklistMode);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        channelFromServer = null;
    }

    private void requestInfoIfNeeded() {
        int id = this.getCardID();
        if (id == -1) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetSecurityInfo(id));
            this.listDirty = 20;
        }
    }

    private void updateChannelName() {
        this.listDirty = 20;
        String channelName = this.channelNameField.getText();
        if (channelFromServer != null) {
            channelFromServer.setName(channelName);
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setChannelName", new Argument[]{new Argument("name", channelName)});
    }

    private void updateSettings() {
        boolean whitelist;
        this.listDirty = 20;
        boolean bl = whitelist = this.blacklistMode.getCurrentChoiceIndex() == 0;
        if (channelFromServer != null) {
            channelFromServer.setWhitelist(whitelist);
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("whitelist", whitelist)});
    }

    private void populatePlayers() {
    }

    private void addPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "addPlayer", new Argument[]{new Argument("player", this.nameField.getText())});
    }

    private void delPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "delPlayer", new Argument[]{new Argument("player", this.nameField.getText())});
    }

    private int getCardID() {
        Slot slot = (Slot)this.field_147002_h.field_75151_b.get(0);
        if (slot.func_75216_d()) {
            NBTTagCompound tagCompound = slot.func_75211_c().func_77978_p();
            if (tagCompound == null) {
                return -1;
            }
            if (tagCompound.func_74764_b("channel")) {
                return tagCompound.func_74762_e("channel");
            }
        }
        return -1;
    }

    private void updateGui() {
        int id = this.getCardID();
        this.blacklistMode.setEnabled(id != -1);
        this.players.setEnabled(id != -1);
        this.addButton.setEnabled(id != -1);
        this.delButton.setEnabled(id != -1);
        this.nameField.setEnabled(id != -1);
        this.channelNameField.setEnabled(id != -1);
        this.players.removeChildren();
        if (id != -1 && channelFromServer != null) {
            this.channelNameField.setText(channelFromServer.getName());
            this.blacklistMode.setCurrentChoice(channelFromServer.isWhitelist() ? 0 : 1);
            for (String player : channelFromServer.getPlayers()) {
                this.players.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(player).setColor(StyleConfig.colorTextInListNormal).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
            }
        } else {
            this.channelNameField.setText("");
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateGui();
        this.drawWindow();
        this.requestInfoIfNeeded();
    }
}

