/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.GuiLevelEmitter;
import mcjty.rftools.blocks.storage.LevelEmitterContainer;
import mcjty.rftools.blocks.storage.LevelEmitterTileEntity;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class LevelEmitterBlock
extends LogicSlabBlock<LevelEmitterTileEntity, LevelEmitterContainer> {
    public static final PropertyBool MODULE = PropertyBool.func_177716_a((String)"module");

    public LevelEmitterBlock() {
        super(Material.field_151573_f, "level_emitter", LevelEmitterTileEntity.class, LevelEmitterContainer.class, true);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiLevelEmitter.class;
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == ScreenSetup.storageControlModuleItem;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This block can be retrofitted with");
            list.add(TextFormatting.WHITE + "a Storage Control Module so that");
            list.add(TextFormatting.WHITE + "you can count items in your storage");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        ItemStack module = LevelEmitterBlock.getModule(world.func_175625_s(data.getPos()));
        if (module == null) {
            probeInfo.text(TextFormatting.GREEN + "Install storage control module first");
        } else {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof LevelEmitterTileEntity) {
                LevelEmitterTileEntity emitterTileEntity = (LevelEmitterTileEntity)te;
                int count = emitterTileEntity.getCurrentCount();
                ItemStack toCount = emitterTileEntity.getInventoryHelper().getStackInSlot(1);
                if (toCount != null) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(toCount).text(TextFormatting.BLUE + "Count: " + TextFormatting.WHITE + count);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        ItemStack module = LevelEmitterBlock.getModule(accessor.getTileEntity());
        if (module == null) {
            currenttip.add(TextFormatting.GREEN + "Install storage control module first");
        }
        return currenttip;
    }

    @Override
    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return RFTools.GUI_STORAGE_TERMINAL;
    }

    private static ItemStack getModule(TileEntity tileEntity) {
        if (tileEntity instanceof LevelEmitterTileEntity) {
            LevelEmitterTileEntity emitterTileEntity = (LevelEmitterTileEntity)tileEntity;
            return emitterTileEntity.func_70301_a(0);
        }
        return null;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        ItemStack module = LevelEmitterBlock.getModule(world.func_175625_s(pos));
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)MODULE, (Comparable)Boolean.valueOf(module != null));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, OUTPUTPOWER, MODULE});
    }
}

