/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestItem
implements IMessage {
    private int dimensionId;
    private BlockPos pos;
    private BlockPos inventoryPos;
    private ItemStack item;
    private int amount;

    public void fromBytes(ByteBuf buf) {
        this.dimensionId = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.inventoryPos = NetworkTools.readPos((ByteBuf)buf);
        this.amount = buf.readInt();
        this.item = NetworkTools.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensionId);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.inventoryPos);
        buf.writeInt(this.amount);
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
    }

    public PacketRequestItem() {
    }

    public PacketRequestItem(int dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, int amount) {
        this.dimensionId = dimensionId;
        this.pos = pos;
        this.inventoryPos = inventoryPos;
        this.item = item;
        this.amount = amount;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestItem, IMessage> {
        public IMessage onMessage(PacketRequestItem message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        public void handle(PacketRequestItem message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dimensionId);
            if (world == null) {
                return;
            }
            if (!RFToolsTools.chunkLoaded((World)world, message.pos)) {
                return;
            }
            TileEntity te = world.func_175625_s(message.pos);
            if (te instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity tileEntity = (StorageScannerTileEntity)te;
                tileEntity.requestStack(message.inventoryPos, message.item, message.amount);
            }
        }
    }
}

