/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.GuiStorageScanner;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;

public class SearchItemsInfoPacketClient
implements InfoPacketClient {
    private Set<BlockPos> inventories;

    public void fromBytes(ByteBuf byteBuf) {
        int size = byteBuf.readInt();
        this.inventories = new HashSet<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            this.inventories.add(NetworkTools.readPos((ByteBuf)byteBuf));
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.inventories.size());
        for (BlockPos pos : this.inventories) {
            NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)pos);
        }
    }

    public SearchItemsInfoPacketClient() {
    }

    public SearchItemsInfoPacketClient(Set<BlockPos> inventories) {
        this.inventories = inventories;
    }

    public void onMessageClient(EntityPlayerSP entityPlayerSP) {
        GuiStorageScanner.fromServer_foundInventories = this.inventories;
    }
}

