/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.GuiMatterReceiver;
import mcjty.rftools.blocks.teleporter.PlayerName;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MatterReceiverTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static final String CMD_SETNAME = "setName";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    public static final String CMD_SETPRIVATE = "setAccess";
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private String name = null;
    private boolean privateAccess = false;
    private Set<String> allowedPlayers = new HashSet<String>();
    private int id = -1;
    private BlockPos cachedPos;

    public MatterReceiverTileEntity() {
        super(TeleportConfiguration.RECEIVER_MAXENERGY, TeleportConfiguration.RECEIVER_RECEIVEPERTICK);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
            this.id = destinations.getNewId(gc);
            destinations.save(this.field_145850_b);
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.markDirtyClient();
    }

    public void setName(String name) {
        this.name = name;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
        if (destination != null) {
            destination.setName(name);
            destinations.save(this.field_145850_b);
        }
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.func_174877_v().equals((Object)this.cachedPos)) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
            destinations.removeDestination(this.cachedPos, this.field_145850_b.field_73011_w.getDimension());
            this.cachedPos = this.func_174877_v();
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.addDestination(gc);
            destinations.save(this.field_145850_b);
            this.func_70296_d();
        }
    }

    public void updateDestination() {
        GlobalCoordinate gc;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination((gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension())).getCoordinate(), gc.getDimension());
        if (destination != null) {
            destination.setName(this.name);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
                this.func_70296_d();
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.save(this.field_145850_b);
        }
        this.markDirtyClient();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.markDirtyClient();
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public List<PlayerName> getAllowedPlayers() {
        ArrayList<PlayerName> p = new ArrayList<PlayerName>();
        for (String player : this.allowedPlayers) {
            p.add(new PlayerName(player));
        }
        return p;
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.markDirtyClient();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.markDirtyClient();
        }
    }

    public int checkStatus() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.field_145850_b, this.func_174877_v().func_177984_a())) {
            return 1;
        }
        block = this.field_145850_b.func_180495_p(this.func_174877_v().func_177981_b(2)).func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.field_145850_b, this.func_174877_v().func_177981_b(2))) {
            return 1;
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < TeleportConfiguration.rfPerTeleportReceiver) {
            return 16;
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cachedPos = new BlockPos(tagCompound.func_74762_e("cachedX"), tagCompound.func_74762_e("cachedY"), tagCompound.func_74762_e("cachedZ"));
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.func_74779_i("tpName");
        this.privateAccess = tagCompound.func_74767_n("private");
        this.allowedPlayers.clear();
        NBTTagList playerList = tagCompound.func_150295_c("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.func_74745_c(); ++i) {
                String player = playerList.func_150307_f(i);
                this.allowedPlayers.add(player);
            }
        }
        this.id = tagCompound.func_74764_b("destinationId") ? tagCompound.func_74762_e("destinationId") : -1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.cachedPos != null) {
            tagCompound.func_74768_a("cachedX", this.cachedPos.func_177958_n());
            tagCompound.func_74768_a("cachedY", this.cachedPos.func_177956_o());
            tagCompound.func_74768_a("cachedZ", this.cachedPos.func_177952_p());
        }
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.func_74778_a("tpName", this.name);
        }
        tagCompound.func_74757_a("private", this.privateAccess);
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.allowedPlayers) {
            playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
        }
        tagCompound.func_74782_a("players", (NBTBase)playerTagList);
        tagCompound.func_74768_a("destinationId", this.id);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName(args.get("name").getString());
            return true;
        }
        if (CMD_SETPRIVATE.equals(command)) {
            this.setPrivateAccess(args.get("private").getBoolean());
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return this.getAllowedPlayers();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterReceiver.storeAllowedPlayersForClient(list);
            return true;
        }
        return false;
    }
}

