/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TeleportDestinations
extends WorldSavedData {
    public static final String TPDESTINATIONS_NAME = "TPDestinations";
    private static TeleportDestinations instance = null;
    private final Map<GlobalCoordinate, TeleportDestination> destinations = new HashMap<GlobalCoordinate, TeleportDestination>();
    private final Map<Integer, GlobalCoordinate> destinationById = new HashMap<Integer, GlobalCoordinate>();
    private final Map<GlobalCoordinate, Integer> destinationIdByCoordinate = new HashMap<GlobalCoordinate, Integer>();
    private int lastId = 0;

    public TeleportDestinations(String identifier) {
        super(identifier);
    }

    public static String getDestinationName(TeleportDestinations destinations, int receiverId) {
        String name;
        GlobalCoordinate coordinate = destinations.getCoordinateForId(receiverId);
        if (coordinate == null) {
            name = "?";
        } else {
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (destination == null) {
                name = "?";
            } else {
                name = destination.getName();
                if (name == null || name.isEmpty()) {
                    name = destination.getCoordinate() + " (" + destination.getDimension() + ")";
                }
            }
        }
        return name;
    }

    public void save(World world) {
        world.func_175693_T().func_75745_a(TPDESTINATIONS_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            TeleportDestinations.instance.destinations.clear();
            TeleportDestinations.instance.destinationById.clear();
            TeleportDestinations.instance.destinationIdByCoordinate.clear();
            instance = null;
        }
    }

    public void cleanupInvalid(World world) {
        HashSet<GlobalCoordinate> keys = new HashSet<GlobalCoordinate>(this.destinations.keySet());
        for (GlobalCoordinate key : keys) {
            World transWorld = TeleportationTools.getWorldForDimension(world, key.getDimension());
            boolean removed = false;
            if (transWorld == null) {
                Logging.log((String)("Receiver on dimension " + key.getDimension() + " removed because world can't be loaded!"));
                removed = true;
            } else {
                TileEntity te;
                BlockPos c = key.getCoordinate();
                try {
                    te = transWorld.func_175625_s(c);
                }
                catch (Exception e) {
                    te = null;
                }
                if (!(te instanceof MatterReceiverTileEntity)) {
                    Logging.log((String)("Receiver at " + c + " on dimension " + key.getDimension() + " removed because there is no receiver there!"));
                    removed = true;
                }
            }
            if (!removed) continue;
            this.destinations.remove(key);
        }
    }

    public static TeleportDestinations getDestinations(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (TeleportDestinations)world.func_175693_T().func_75742_a(TeleportDestinations.class, TPDESTINATIONS_NAME);
        if (instance == null) {
            instance = new TeleportDestinations(TPDESTINATIONS_NAME);
        }
        return instance;
    }

    public Collection<TeleportDestinationClientInfo> getValidDestinations(World worldObj, String playerName) {
        FavoriteDestinationsProperties properties = null;
        if (playerName != null) {
            List list = worldObj.func_73046_m().func_184103_al().func_181057_v();
            for (EntityPlayerMP entityplayermp : list) {
                if (!playerName.equals(entityplayermp.func_70005_c_())) continue;
                properties = PlayerExtendedProperties.getFavoriteDestinations((EntityPlayer)entityplayermp);
                break;
            }
        }
        ArrayList<TeleportDestinationClientInfo> result = new ArrayList<TeleportDestinationClientInfo>();
        for (TeleportDestination destination : this.destinations.values()) {
            TileEntity te;
            TeleportDestinationClientInfo destinationClientInfo = new TeleportDestinationClientInfo(destination);
            BlockPos c = destination.getCoordinate();
            WorldServer world = DimensionManager.getWorld((int)destination.getDimension());
            String dimName = null;
            if (world != null) {
                dimName = DimensionManager.getProvider((int)destination.getDimension()).func_186058_p().func_186065_b();
            }
            dimName = dimName == null || dimName.trim().isEmpty() ? "Id " + destination.getDimension() : dimName + " (" + destination.getDimension() + ")";
            destinationClientInfo.setDimensionName(dimName);
            if (world != null && (te = world.func_175625_s(c)) instanceof MatterReceiverTileEntity) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                if (playerName != null && !matterReceiverTileEntity.checkAccess(playerName)) continue;
            }
            if (properties != null) {
                destinationClientInfo.setFavorite(properties.isDestinationFavorite(new GlobalCoordinate(c, destination.getDimension())));
            }
            result.add(destinationClientInfo);
        }
        Collections.sort(result);
        return result;
    }

    public boolean isDestinationValid(TeleportDestination destination) {
        GlobalCoordinate key = new GlobalCoordinate(destination.getCoordinate(), destination.getDimension());
        return this.destinations.containsKey(key);
    }

    public void assignId(GlobalCoordinate key, int id) {
        this.destinationById.put(id, key);
        this.destinationIdByCoordinate.put(key, id);
    }

    public int getNewId(GlobalCoordinate key) {
        if (this.destinationIdByCoordinate.containsKey(key)) {
            return this.destinationIdByCoordinate.get(key);
        }
        ++this.lastId;
        this.destinationById.put(this.lastId, key);
        this.destinationIdByCoordinate.put(key, this.lastId);
        return this.lastId;
    }

    public Integer getIdForCoordinate(GlobalCoordinate key) {
        return this.destinationIdByCoordinate.get(key);
    }

    public GlobalCoordinate getCoordinateForId(int id) {
        return this.destinationById.get(id);
    }

    public TeleportDestination addDestination(GlobalCoordinate key) {
        if (!this.destinations.containsKey(key)) {
            TeleportDestination teleportDestination = new TeleportDestination(key.getCoordinate(), key.getDimension());
            this.destinations.put(key, teleportDestination);
        }
        return this.destinations.get(key);
    }

    public void removeDestinationsInDimension(int dimension) {
        HashSet<GlobalCoordinate> keysToRemove = new HashSet<GlobalCoordinate>();
        for (Map.Entry<GlobalCoordinate, TeleportDestination> entry : this.destinations.entrySet()) {
            if (entry.getKey().getDimension() != dimension) continue;
            keysToRemove.add(entry.getKey());
        }
        for (GlobalCoordinate key : keysToRemove) {
            this.removeDestination(key.getCoordinate(), key.getDimension());
        }
    }

    public void removeDestination(BlockPos coordinate, int dimension) {
        if (coordinate == null) {
            return;
        }
        GlobalCoordinate key = new GlobalCoordinate(coordinate, dimension);
        this.destinations.remove(key);
        Integer id = this.destinationIdByCoordinate.get(key);
        if (id != null) {
            this.destinationById.remove(id);
            this.destinationIdByCoordinate.remove(key);
        }
    }

    public TeleportDestination getDestination(GlobalCoordinate coordinate) {
        return this.destinations.get(coordinate);
    }

    public TeleportDestination getDestination(BlockPos coordinate, int dimension) {
        return this.destinations.get(new GlobalCoordinate(coordinate, dimension));
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.destinations.clear();
        this.destinationById.clear();
        this.destinationIdByCoordinate.clear();
        this.lastId = tagCompound.func_74762_e("lastId");
        this.readDestinationsFromNBT(tagCompound);
    }

    private void readDestinationsFromNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            int dim = tc.func_74762_e("dim");
            String name = tc.func_74779_i("name");
            TeleportDestination destination = new TeleportDestination(c, dim);
            destination.setName(name);
            GlobalCoordinate gc = new GlobalCoordinate(c, dim);
            this.destinations.put(gc, destination);
            if (!tc.func_74764_b("id")) continue;
            int id = tc.func_74762_e("id");
            this.destinationById.put(id, gc);
            this.destinationIdByCoordinate.put(gc, id);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        TeleportDestinations.writeDestinationsToNBT(tagCompound, this.destinations.values(), this.destinationIdByCoordinate);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    private static void writeDestinationsToNBT(NBTTagCompound tagCompound, Collection<TeleportDestination> destinations, Map<GlobalCoordinate, Integer> coordinateToInteger) {
        NBTTagList lst = new NBTTagList();
        for (TeleportDestination destination : destinations) {
            Integer id;
            NBTTagCompound tc = new NBTTagCompound();
            BlockPos c = destination.getCoordinate();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74768_a("dim", destination.getDimension());
            tc.func_74778_a("name", destination.getName());
            if (coordinateToInteger != null && (id = coordinateToInteger.get(new GlobalCoordinate(c, destination.getDimension()))) != null) {
                tc.func_74768_a("id", id.intValue());
            }
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("destinations", (NBTBase)lst);
    }
}

