/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.rftools.blocks.logic.wireless.RedstoneReceiverTileEntity;
import mcjty.rftools.blocks.logic.wireless.RedstoneTransmitterTileEntity;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ButtonScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.ButtonClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ButtonModuleItem
extends GenericRFToolsItem
implements IModuleProvider {
    public ButtonModuleItem() {
        super("button_module");
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    public Class<? extends IScreenModule> getServerScreenModule() {
        return ButtonScreenModule.class;
    }

    @Override
    public Class<? extends IClientScreenModule> getClientScreenModule() {
        return ButtonClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "Button";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.BUTTON_RFPERTICK + " RF/tick");
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text"));
            int channel = tagCompound.func_74762_e("channel");
            if (channel != -1) {
                list.add(TextFormatting.YELLOW + "Channel: " + channel);
            }
        }
        list.add(TextFormatting.WHITE + "Sneak right-click on a redstone receiver");
        list.add(TextFormatting.WHITE + "to create a channel for this module and also");
        list.add(TextFormatting.WHITE + "set it to the receiver. You can also use this");
        list.add(TextFormatting.WHITE + "on a transmitter or already set receiver to copy");
        list.add(TextFormatting.WHITE + "the channel to the button");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        int channel = -1;
        if (tagCompound.func_74764_b("channel")) {
            channel = tagCompound.func_74762_e("channel");
        }
        if (te instanceof RedstoneTransmitterTileEntity) {
            int blockChannel = ((RedstoneTransmitterTileEntity)te).getChannel();
            if (channel == -1 && blockChannel != -1) {
                Logging.message((EntityPlayer)player, (String)("Copied channel " + blockChannel + " to Button module"));
                tagCompound.func_74768_a("channel", blockChannel);
                return EnumActionResult.SUCCESS;
            }
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Nothing happens!"));
        } else if (te instanceof RedstoneReceiverTileEntity) {
            int blockChannel = ((RedstoneReceiverTileEntity)te).getChannel();
            if (channel == -1) {
                if (blockChannel != -1) {
                    Logging.message((EntityPlayer)player, (String)("Copied channel " + blockChannel + " to Button module"));
                    tagCompound.func_74768_a("channel", blockChannel);
                    return EnumActionResult.SUCCESS;
                }
                RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                channel = redstoneChannels.newChannel();
                redstoneChannels.save(world);
                Logging.message((EntityPlayer)player, (String)("Created channel " + channel + " for Button module"));
                tagCompound.func_74768_a("channel", channel);
            }
            ((RedstoneReceiverTileEntity)te).setChannel(channel);
            Logging.message((EntityPlayer)player, (String)("Receiver is set to channel " + channel));
        } else {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You can only use this on a redstone receiver/transmitter!"));
        }
        return EnumActionResult.SUCCESS;
    }
}

