/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.items.teleportprobe.PacketAllReceiversReady;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetAllReceivers
implements IMessage {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<PacketGetAllReceivers, IMessage> {
        public IMessage onMessage(PacketGetAllReceivers message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetAllReceivers message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TeleportDestinations destinations = TeleportDestinations.getDestinations(player.field_70170_p);
            ArrayList<TeleportDestinationClientInfo> destinationList = new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(player.field_70170_p, null));
            this.addDimensions(destinationList);
            this.addRfToolsDimensions(player.field_70170_p, destinationList);
            PacketAllReceiversReady msg = new PacketAllReceiversReady(destinationList);
            RFToolsMessages.INSTANCE.sendTo((IMessage)msg, player);
        }

        private void addDimensions(List<TeleportDestinationClientInfo> destinationList) {
            WorldServer[] worlds;
            for (WorldServer world : worlds = DimensionManager.getWorlds()) {
                int id = world.field_73011_w.getDimension();
                TeleportDestination destination = new TeleportDestination(new BlockPos(0, 70, 0), id);
                destination.setName("Dimension: " + id);
                TeleportDestinationClientInfo teleportDestinationClientInfo = new TeleportDestinationClientInfo(destination);
                String dimName = world.field_73011_w.func_186058_p().func_186065_b();
                teleportDestinationClientInfo.setDimensionName(dimName);
                destinationList.add(teleportDestinationClientInfo);
            }
        }

        private void addRfToolsDimensions(World world, List<TeleportDestinationClientInfo> destinationList) {
        }
    }
}

