/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.machine;

import com.google.common.collect.Iterators;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class MachineRecipeRegistry
implements Iterable<IMachineRecipe> {
    private final IdentityHashMap<IMachineRecipe, ModContainer> toBlameMap = new IdentityHashMap();
    private final List<IMachineRecipe> recipes = new ArrayList<IMachineRecipe>();

    public void addRecipe(IMachineRecipe recipe) {
        this.recipes.add(recipe);
        this.toBlameMap.put(recipe, Loader.instance().activeModContainer());
    }

    public boolean removeRecipe(IMachineRecipe recipe) {
        if (this.recipes.remove(recipe)) {
            this.toBlameMap.remove(recipe);
            return true;
        }
        return false;
    }

    public ModContainer getOwner(IMachineRecipe recipe) {
        return this.toBlameMap.get(recipe);
    }

    @Override
    public Iterator<IMachineRecipe> iterator() {
        return Iterators.unmodifiableIterator(this.recipes.iterator());
    }

    public boolean contains(IMachineRecipe recipe) {
        return this.toBlameMap.containsKey(recipe);
    }
}

