/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxRotatable;
import com.rwtema.extrautils2.backend.model.CachedRenderers;
import com.rwtema.extrautils2.backend.model.IClientClearCache;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BoxModel
extends ArrayList<Box>
implements IClientClearCache {
    public static final float OVERLAP = 0.0f;
    public boolean renderAsNormalBlock;
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite sprite;
    public Box overrideBounds;
    private byte passableFlag;

    public BoxModel() {
    }

    public BoxModel(Box newBox) {
        super(1);
        this.add(newBox);
    }

    public BoxModel(float par1, float par3, float par5, float par7, float par9, float par11) {
        super(1);
        this.add(new Box(par1, par3, par5, par7, par9, par11));
    }

    public static BoxModel newStandardBlock() {
        Box t = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        BoxModel boxes = new BoxModel(t);
        boxes.renderAsNormalBlock = true;
        return boxes;
    }

    public static BoxModel newStandardBlock(boolean dummy) {
        BoxModel boxes = new BoxModel();
        boxes.renderAsNormalBlock = true;
        return boxes;
    }

    public static BoxModel newStandardBlock(String texture) {
        Box t = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        t.texture = texture;
        BoxModel boxes = new BoxModel(t);
        boxes.renderAsNormalBlock = true;
        return boxes;
    }

    public static BoxModel hollowBox(float minX, float minY, float minZ, float holeMinX, float holeMinZ, float holeMaxX, float holeMaxZ, float maxX, float maxY, float maxZ) {
        BoxModel t = new BoxModel();
        t.add(new Box(minX, minY, minZ, holeMinX, maxY, maxZ));
        t.add(new Box(holeMinX, minY, minZ, holeMaxX, maxY, holeMinZ));
        t.add(new Box(holeMinX, minY, holeMaxZ, holeMaxX, maxY, maxZ));
        t.add(new Box(holeMaxX, minY, minZ, maxX, maxY, maxZ));
        return t;
    }

    public static Box boundingBox(BoxModel models, boolean collideOnly) {
        if (models == null) {
            return null;
        }
        if (models.overrideBounds != null) {
            if (collideOnly) {
                for (Box box : models) {
                    if (box.noCollide) continue;
                    return models.overrideBounds;
                }
                return null;
            }
            return models.overrideBounds;
        }
        if (models.isEmpty()) {
            return null;
        }
        Box bounds = null;
        for (Box box : models) {
            if (collideOnly && box.noCollide) continue;
            if (bounds != null) {
                bounds.increaseBounds(box);
                continue;
            }
            bounds = new Box(box);
        }
        return bounds;
    }

    public static BoxModel crossBoxModel() {
        float size = 0.2f;
        BoxModel model = new BoxModel();
        BoxRotatable box1 = new BoxRotatable(0.5f, 0.0f, -size, 0.5f, 1.0f, 1.0f + size);
        box1.setInvisible(15);
        box1.rotate(1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f);
        box1.setTextureBounds(new float[][]{null, null, null, null, {0.0f, 0.0f, 16.0f, 16.0f}, {0.0f, 0.0f, 16.0f, 16.0f}});
        model.add(box1);
        BoxRotatable box2 = new BoxRotatable(0.5f, 0.0f, -size, 0.5f, 1.0f, 1.0f + size);
        box2.setInvisible(15);
        box2.setTextureBounds(new float[][]{null, null, null, null, {0.0f, 0.0f, 16.0f, 16.0f}, {0.0f, 0.0f, 16.0f, 16.0f}});
        box2.rotate(1.0f, -1.0f, 0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f);
        model.add(box2);
        return model;
    }

    public AxisAlignedBB getAABB(boolean collideOnly) {
        Box box = BoxModel.boundingBox(this, collideOnly);
        return box != null ? new AxisAlignedBB((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ) : null;
    }

    public Box addBoxOverlay(float h) {
        return this.addBox(-h, -h, -h, 1.0f + h, 1.0f + h, 1.0f + h);
    }

    public Box addBoxI(int par1, int par3, int par5, int par7, int par9, int par11) {
        return this.addBox((float)par1 / 16.0f - 0.0f, (float)par3 / 16.0f - 0.0f, (float)par5 / 16.0f - 0.0f, (float)par7 / 16.0f + 0.0f, (float)par9 / 16.0f + 0.0f, (float)par11 / 16.0f + 0.0f);
    }

    public Box addBoxI(int par1, int par3, int par5, int par7, int par9, int par11, String texture) {
        return this.addBox((float)par1 / 16.0f - 0.0f, (float)par3 / 16.0f - 0.0f, (float)par5 / 16.0f - 0.0f, (float)par7 / 16.0f + 0.0f, (float)par9 / 16.0f + 0.0f, (float)par11 / 16.0f + 0.0f).setTexture(texture);
    }

    public Box addBox(float par1, float par3, float par5, float par7, float par9, float par11) {
        Box b = new Box(par1, par3, par5, par7, par9, par11);
        this.add(b);
        return b;
    }

    public BoxModel rotateToSide(EnumFacing dir) {
        for (Box box : this) {
            box.rotateToSide(dir);
        }
        return this;
    }

    public BoxModel rotateY(EnumFacing side) {
        switch (side) {
            case EAST: {
                this.rotateY(1);
                break;
            }
            case SOUTH: {
                this.rotateY(2);
                break;
            }
            case WEST: {
                this.rotateY(3);
            }
        }
        return this;
    }

    public BoxModel rotateY(int numRotations) {
        for (Box box : this) {
            box.rotateY(numRotations);
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public MutableModel loadIntoMutable(MutableModel result, BlockRenderLayer layer) {
        result.clear();
        result.ambientOcclusion = true;
        result.isGui3D = true;
        for (Box box : this) {
            if (result.tex == null) {
                result.tex = box.getTex();
            }
            if (layer != null && box.layer != layer) continue;
            for (EnumFacing facing : EnumFacing.values()) {
                List<BakedQuad> bakedQuads = box.getQuads(facing);
                if (bakedQuads == null) continue;
                if (box.isFlush(facing)) {
                    ((ArrayList)result.sidedQuads.get(facing.func_176745_a())).addAll(bakedQuads);
                    continue;
                }
                result.generalQuads.addAll(bakedQuads);
            }
            List<BakedQuad> bakedQuads = box.getQuads(null);
            if (bakedQuads == null) continue;
            result.generalQuads.addAll(bakedQuads);
        }
        return result;
    }

    public BoxModel setTextures(Object ... objects) {
        for (Box box : this) {
            box.setTextureSides(objects);
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTex() {
        if (this.sprite != null) {
            return this.sprite;
        }
        for (Box box : this) {
            this.sprite = box.getTex();
            if (this.sprite == null) continue;
            CachedRenderers.register(this);
            return this.sprite;
        }
        return Textures.MISSING_SPRITE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientClear() {
        this.sprite = null;
    }

    public boolean isFullCube() {
        return this.renderAsNormalBlock;
    }

    public BoxModel setTexture(String s) {
        for (Box box : this) {
            box.setTexture(s);
        }
        return this;
    }

    public BoxModel setLayer(BlockRenderLayer layer) {
        for (Box box : this) {
            box.setLayer(layer);
        }
        return this;
    }

    public AxisAlignedBB getAABB(BlockPos pos, boolean collideOnly) {
        AxisAlignedBB aabb = this.getAABB(collideOnly);
        if (aabb == null) {
            return null;
        }
        return aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public boolean getPassable() {
        if (this.passableFlag == 0) {
            this.passableFlag = (byte)2;
            for (Box box : this) {
                if (box.noCollide || !((double)box.maxY > 0.5)) continue;
                this.passableFlag = 1;
                break;
            }
        }
        return this.passableFlag == 2;
    }

    public BoxModel copy() {
        BoxModel model = new BoxModel();
        model.renderAsNormalBlock = this.renderAsNormalBlock;
        model.overrideBounds = this.overrideBounds;
        model.passableFlag = this.passableFlag;
        for (Box box : this) {
            model.add(box.copy());
        }
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (Box box : this) {
            Textures.register(box.texture);
            Textures.register(box.textureSide);
        }
    }

    public void moveToCenterForInventoryRendering() {
        Box bounds = BoxModel.boundingBox(this, false);
        float dx = 0.5f - (bounds.maxX + bounds.minX) / 2.0f;
        float dy = 0.0f - bounds.minY;
        float dz = 0.5f - (bounds.maxZ + bounds.minZ) / 2.0f;
        if (dx != 0.0f || dz != 0.0f || dy != 0.0f) {
            for (Box box : this) {
                box.setRenderOffset(dx, dy, dz);
            }
        }
    }
}

