/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.NullModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class PassthruModelItem
extends NullModel {
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads2dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h()));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g()));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> pseudoQuads2dCache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads3dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                bakedQuads = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, (Optional)Optional.of((Object)TRSRTransformation.identity()));
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuad>> tintedQuads = new TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuad>>(){

        public WeakHashMap<BakedQuad, BakedQuad> get(final int key) {
            WeakHashMap weakHashMap = (WeakHashMap)super.get(key);
            if (weakHashMap != null) {
                return weakHashMap;
            }
            weakHashMap = new WeakHashMap<BakedQuad, BakedQuad>(){

                @Override
                public BakedQuad get(Object quadKey) {
                    BakedQuad quadTint = (BakedQuad)super.get(quadKey);
                    if (quadTint != null) {
                        return quadTint;
                    }
                    BakedQuad quad = (BakedQuad)quadKey;
                    quadTint = new BakedQuad(quad.func_178209_a(), key, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
                    this.put(quad, quadTint);
                    return quadTint;
                }
            };
            this.put(key, weakHashMap);
            return weakHashMap;
        }
    };
    protected final IXUItem item;
    protected Supplier<ModelLayer> modelFactory;
    protected ItemOverrideList overrideList = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            ModelLayer model = (ModelLayer)PassthruModelItem.this.modelFactory.get();
            PassthruModelItem.this.item.addQuads(model, stack);
            return model;
        }
    };

    public PassthruModelItem(IXUItem item) {
        this(item, item.renderAsTool() ? Transforms.itemToolsTransforms : Transforms.itemTransforms);
    }

    public PassthruModelItem(IXUItem item, EnumMap<ItemCameraTransforms.TransformType, Matrix4f> transforms) {
        this(item, (Supplier<ModelLayer>)((Supplier)() -> new ModelLayer(transforms)));
    }

    public PassthruModelItem(IXUItem item, Supplier<ModelLayer> model) {
        this.item = item;
        this.modelFactory = model;
    }

    public static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    public static List<BakedQuad> buildFrontQuads(TextureAtlasSprite sprite, TextureAtlasSprite override) {
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        VertexFormat format = DefaultVertexFormats.field_176599_b;
        ImmutableList.Builder builder = ImmutableList.builder();
        int[] pixels = sprite.func_147965_a(0)[0];
        for (int v = 0; v < vMax; ++v) {
            for (int u = 0; u < uMax; ++u) {
                int color = pixels[u + (vMax - 1 - v) * uMax];
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0) continue;
                float u0 = (float)u / (float)uMax;
                float u1 = ((float)u + 1.0f) / (float)uMax;
                float v0 = (float)v / (float)vMax;
                float v1 = ((float)v + 1.0f) / (float)vMax;
                float ou0 = override.func_94214_a((double)(16.0f * u0));
                float ou1 = override.func_94214_a((double)(16.0f * u1));
                float ov0 = override.func_94207_b((double)(16.0f * v0));
                float ov1 = override.func_94207_b((double)(16.0f * v1));
                int b = 255;
                if (u != 0 && v != 0 && u != uMax - 1 && v != vMax - 1) {
                    block2: for (int du = -1; du <= 1; ++du) {
                        for (int dv = -1; dv <= 1; ++dv) {
                            if ((pixels[u + du + (vMax - 1 - v + dv) * uMax] >> 24 & 0xFF) != 0) continue;
                            if (du == 0 || dv == 0) {
                                b = 120;
                                break block2;
                            }
                            b = 200;
                        }
                    }
                }
                b = (ColorHelper.brightness(color) * 40 + b * 216) / 256;
                color = ColorHelper.color(b, b, b, alpha);
                builder.add((Object)QuadHelper.buildQuad(format, TRSRTransformation.identity(), EnumFacing.NORTH, -1, u0, v0, 0.46875f, ou0, ov1, u1, v0, 0.46875f, ou1, ov1, u1, v1, 0.46875f, ou1, ov0, u0, v1, 0.46875f, ou0, ov0, color));
                builder.add((Object)QuadHelper.buildQuad(format, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, u0, v0, 0.53125f, ou0, ov1, u0, v1, 0.53125f, ou0, ov0, u1, v1, 0.53125f, ou1, ov0, u1, v0, 0.53125f, ou1, ov1, color));
            }
        }
        return builder.build();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.item.getBaseTexture();
    }

    public static class ModelLayer
    extends MutableModel {
        static ItemCameraTransforms.TransformType[] types = new ItemCameraTransforms.TransformType[]{ItemCameraTransforms.TransformType.GUI, ItemCameraTransforms.TransformType.NONE};
        public MutableModel lowPolyVersion;

        public ModelLayer(EnumMap<ItemCameraTransforms.TransformType, Matrix4f> itemTransforms) {
            super(itemTransforms);
            this.isGui3D = false;
            this.ambientOcclusion = false;
            this.lowPolyVersion = new MutableModel(itemTransforms);
            for (ItemCameraTransforms.TransformType type : types) {
                this.transformMap.put(type, Pair.of((Object)this.lowPolyVersion, (Object)((Pair)this.transformMap.get(type)).getRight()));
            }
        }

        public void addBoxModel(BoxModel boxModel) {
            for (Box box : boxModel) {
                for (EnumFacing facing : EnumFacing.values()) {
                    List<BakedQuad> quads = box.getQuads(facing);
                    if (quads == null) continue;
                    this.addAllQuads(quads);
                }
                List<BakedQuad> quads = box.getQuads(null);
                if (quads == null) continue;
                this.addAllQuads(quads);
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.lowPolyVersion.clear();
        }

        public void addSprite(TextureAtlasSprite sprite) {
            this.generalQuads.addAll((Collection)quads3dcache.get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addSprite(TextureAtlasSprite sprite, boolean draw3d) {
            this.generalQuads.addAll((Collection)(draw3d ? quads3dcache : quads2dcache).get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addTintedSprite(TextureAtlasSprite sprite, boolean draw3d, int tint) {
            if (tint == -1) {
                this.addSprite(sprite, draw3d);
            } else {
                for (BakedQuad bakedQuad : (draw3d ? quads3dcache : quads2dcache).get(sprite)) {
                    this.generalQuads.add(((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
                for (BakedQuad bakedQuad : quads2dcache.get(sprite)) {
                    this.lowPolyVersion.generalQuads.add((BakedQuad)((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
            }
        }

        public void addQuad(BakedQuad quad) {
            this.generalQuads.add(quad);
            this.lowPolyVersion.generalQuads.add(quad);
        }

        public void addAllQuads(Collection<BakedQuad> quads) {
            this.generalQuads.addAll(quads);
            this.lowPolyVersion.generalQuads.addAll(quads);
        }
    }
}

