/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.crafting.AlwaysLast;
import com.rwtema.extrautils2.crafting.XUShapedRecipe;
import com.rwtema.extrautils2.crafting.XUShapelessRecipe;
import com.rwtema.extrautils2.utils.LogHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingHelper {
    private static final Set<Class<? extends IRecipe>> registeredRecipes = new HashSet<Class<? extends IRecipe>>();
    public static final ThreadLocal<Collection<? super IRecipe>> recipeCallback = new ThreadLocal();

    public static void addRecipe(IRecipe recipe) {
        Collection<? super IRecipe> objects = recipeCallback.get();
        if (objects != null) {
            objects.add((IRecipe)recipe);
        }
        CraftingHelper.registerRecipe(recipe.getClass());
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    public static void addShapeless(ItemStack stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(stack, recipe));
    }

    public static void addShaped(ItemStack stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(stack, recipe));
    }

    public static void addShapeless(Item stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(stack, recipe));
    }

    public static void addShaped(Item stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(stack, recipe));
    }

    public static void addShapeless(Block stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(stack, recipe));
    }

    public static void addShaped(Block stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(stack, recipe));
    }

    public static void registerRecipe(Class<? extends IRecipe> recipe) {
        if (registeredRecipes.contains(recipe)) {
            return;
        }
        if (!recipe.getName().startsWith("com.rwtema.")) {
            return;
        }
        registeredRecipes.add(recipe);
        LogHelper.fine("Registering " + recipe.getSimpleName() + " to RecipeSorter", new Object[0]);
        if (ShapedOreRecipe.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        } else if (ShapelessOreRecipe.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore before:extrautils2:alwaysLastShapeless");
        } else if (ShapedRecipes.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        } else if (ShapelessRecipes.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless before:minecraft:bookcloning before:extrautils2:alwaysLastShapeless");
        } else {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore before:extrautils2:alwaysLastShapeless");
        }
    }

    public static void registerRecipe(Class<? extends IRecipe> recipe, RecipeSorter.Category cat, String s) {
        if (registeredRecipes.contains(recipe)) {
            return;
        }
        registeredRecipes.add(recipe);
        RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)cat, (String)s);
    }

    static {
        registeredRecipes.add(AlwaysLast.XUShapedRecipeAlwaysLast.class);
        RecipeSorter.register((String)"extrautils2:alwaysLastShaped", AlwaysLast.XUShapedRecipeAlwaysLast.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped after:minecraft:shapeless after:forge:shapedore after:forge:shapelessore after:minecraft:repair after:minecraft:pattern_add after:minecraft:mapextending after:minecraft:armordyes after:minecraft:fireworks after:minecraft:bookcloning");
        registeredRecipes.add(AlwaysLast.XUShapelessRecipeAlwaysLast.class);
        RecipeSorter.register((String)"extrautils2:alwaysLastShapeless", AlwaysLast.XUShapedRecipeAlwaysLast.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped after:minecraft:shapeless after:forge:shapedore after:forge:shapelessore after:minecraft:repair after:minecraft:pattern_add after:minecraft:mapextending after:minecraft:armordyes after:minecraft:fireworks after:minecraft:bookcloning");
    }
}

