/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.machine.BlockMachine;
import gnu.trove.map.TObjectFloatMap;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.ingredients.IIngredientHelper;
import mezz.jei.gui.ingredients.IIngredientRenderer;
import mezz.jei.gui.ingredients.ItemStackHelper;
import mezz.jei.gui.ingredients.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class JEIMachine
implements IRecipeCategory {
    public static final int height;
    public static final int sloty;
    public static final int texty;
    public static final int padding;
    public static final int arrowy;
    private static final ItemStackHelper helper;
    public final int width;
    public final IDrawableStatic arrowBack;
    final Machine machine;
    private final IDrawableAnimated arrow;
    IDrawable slotDrawable = XUJEIPlugin.jeiHelpers.getGuiHelper().getSlotDrawable();
    IDrawable background;

    public JEIMachine(Machine machine) {
        this.machine = machine;
        this.width = (machine.itemInputs.size() + machine.itemOutputs.size()) * 22 + 4 + 22;
        IGuiHelper guiHelper = XUJEIPlugin.jeiHelpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(this.width, height);
        this.arrowBack = guiHelper.createDrawable(DynamicGui.texWidgets, 98, 0, 22, 16);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(DynamicGui.texWidgets, 98, 16, 22, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public static String getString(Machine machine) {
        return "xu2_machine_" + machine.name;
    }

    @Nonnull
    public String getUid() {
        return JEIMachine.getString(this.machine);
    }

    @Nonnull
    public String getTitle() {
        return BlockMachine.getDisplayName(this.machine);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        int x = 0;
        for (MachineSlotItem ignored : this.machine.itemInputs) {
            this.slotDrawable.draw(minecraft, x, sloty);
            x += 22;
        }
        this.arrowBack.draw(minecraft, x, arrowy);
        x += 26;
        for (MachineSlotItem ignored : this.machine.itemOutputs) {
            this.slotDrawable.draw(minecraft, x, sloty);
            x += 22;
        }
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, this.machine.itemInputs.size() * 22, arrowy);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        JEIMachineRecipe.Wrapper wrapper = (JEIMachineRecipe.Wrapper)recipeWrapper;
        final JEIMachineRecipe recipe = wrapper.parentRecipe;
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        final GuiItemStackGroup group = (GuiItemStackGroup)recipeLayout.getItemStacks();
        int x = 0;
        int index = 0;
        final HashMap<MachineSlotItem, GuiIngredient> inputStackGuiSlots = new HashMap<MachineSlotItem, GuiIngredient>();
        List<MachineSlotItem> itemInputs = this.machine.itemInputs;
        for (MachineSlotItem slot : itemInputs) {
            group.init(index, true, x, sloty);
            IGuiIngredient iGuiIngredient = (IGuiIngredient)group.getGuiIngredients().get(index);
            inputStackGuiSlots.put(slot, (GuiIngredient)iGuiIngredient);
            group.set(index, (Collection)recipe.inputs.get(slot));
            x += 22;
            ++index;
        }
        x += 26;
        List<MachineSlotItem> itemOutputs = this.machine.itemOutputs;
        for (final MachineSlotItem slot : itemOutputs) {
            ItemStackRenderer renderer = new ItemStackRenderer();
            final int indexFinal = index;
            GuiIngredient<ItemStack> guiIngredient = new GuiIngredient<ItemStack>((IIngredientRenderer)renderer, (IIngredientHelper)helper, index, false, x, sloty, 18, 18, 1, 0){

                @Nullable
                public ItemStack getIngredient() {
                    HashMap<MachineSlotItem, ItemStack> stack = new HashMap<MachineSlotItem, ItemStack>();
                    for (MachineSlotItem slot2 : JEIMachine.this.machine.itemInputs) {
                        stack.put(slot2, (ItemStack)((GuiIngredient)inputStackGuiSlots.get(slot2)).getIngredient());
                    }
                    if (!recipe.recipe.matches(stack, recipe.fluids)) {
                        return null;
                    }
                    Map<MachineSlotItem, ItemStack> itemOutputs1 = recipe.recipe.getItemOutputs(stack, recipe.fluids);
                    ItemStack itemStack = itemOutputs1.get(slot);
                    if (itemStack == null) {
                        return null;
                    }
                    group.setFromRecipe(indexFinal, (Object)itemStack);
                    return (ItemStack)super.getIngredient();
                }
            };
            Map guiIngredients = group.getGuiIngredients();
            guiIngredients.put(index, guiIngredient);
            group.set(index, (Collection)ImmutableList.of((Object)new ItemStack(Items.field_151055_y)));
            wrapper.localSlots = new WeakReference(inputStackGuiSlots);
            ++index;
            x += 22;
        }
    }

    static {
        helper = new ItemStackHelper();
        padding = 8;
        height = padding + 18 + 4 + 9 + padding;
        sloty = padding;
        texty = padding + 18 + 4;
        arrowy = sloty;
    }

    public static class JEIMachineRecipe {
        public Machine machine;
        public IMachineRecipe recipe;
        public Map<MachineSlotItem, List<ItemStack>> inputs;
        public Map<MachineSlotFluid, FluidStack> fluids;

        public JEIMachineRecipe(Machine machine, IMachineRecipe recipe, Map<MachineSlotItem, List<ItemStack>> inputs, Map<MachineSlotFluid, FluidStack> fluids) {
            this.machine = machine;
            this.recipe = recipe;
            this.inputs = inputs;
            this.fluids = fluids;
        }

        public Wrapper createWrapper() {
            return new Wrapper(this);
        }

        public static class Wrapper
        implements IRecipeWrapper {
            public final JEIMachineRecipe parentRecipe;
            public WeakReference<HashMap<MachineSlotItem, GuiIngredient<ItemStack>>> localSlots;

            public Wrapper(JEIMachineRecipe parentRecipe) {
                this.parentRecipe = parentRecipe;
            }

            public List getInputs() {
                ArrayList<List<ItemStack>> objects = new ArrayList<List<ItemStack>>();
                for (MachineSlotItem slot : this.parentRecipe.machine.itemInputs) {
                    List<ItemStack> stacks = this.parentRecipe.inputs.get(slot);
                    objects.add(stacks);
                }
                return objects;
            }

            public <K extends MachineSlot<V>, V> Map<K, V> buildMap(List<K> list, Map<K, List<V>> inputs) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (MachineSlot k : list) {
                    List<V> objects = inputs.get(k);
                    Object v = objects.stream().findAny().orElse(null);
                    builder.put((Object)k, v);
                }
                return builder.build();
            }

            public List getOutputs() {
                Map<MachineSlotItem, ItemStack> items = this.buildMap(this.parentRecipe.machine.itemInputs, this.parentRecipe.inputs);
                Map<MachineSlotItem, ItemStack> itemOutputs = this.parentRecipe.recipe.getItemOutputs(items, this.parentRecipe.fluids);
                return itemOutputs.values().stream().filter(f -> f != null).collect(Collectors.toList());
            }

            public List<FluidStack> getFluidInputs() {
                return ImmutableList.copyOf(this.parentRecipe.fluids.values());
            }

            public List<FluidStack> getFluidOutputs() {
                Map<MachineSlotItem, ItemStack> items = this.buildMap(this.parentRecipe.machine.itemInputs, this.parentRecipe.inputs);
                Map<MachineSlotFluid, FluidStack> itemOutputs = this.parentRecipe.recipe.getFluidOutputs(items, this.parentRecipe.fluids);
                return ImmutableList.copyOf(itemOutputs.values());
            }

            public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
                if (this.localSlots == null) {
                    return;
                }
                HashMap inputStackGuiSlots = (HashMap)this.localSlots.get();
                if (inputStackGuiSlots == null) {
                    return;
                }
                HashMap<MachineSlotItem, ItemStack> stack = new HashMap<MachineSlotItem, ItemStack>();
                for (MachineSlotItem slot : this.parentRecipe.machine.itemInputs) {
                    stack.put(slot, (ItemStack)((GuiIngredient)inputStackGuiSlots.get(slot)).getIngredient());
                }
                if (!this.parentRecipe.recipe.matches(stack, this.parentRecipe.fluids)) {
                    return;
                }
                TObjectFloatMap<MachineSlot> probabilityModifier = this.parentRecipe.recipe.getProbabilityModifier(stack, this.parentRecipe.fluids);
                if (probabilityModifier == null) {
                    return;
                }
                int x = this.parentRecipe.machine.itemInputs.size() * 22;
                x += 26;
                for (MachineSlotItem slot : this.parentRecipe.machine.itemOutputs) {
                    float v;
                    if (probabilityModifier.containsKey((Object)slot) && (double)(v = probabilityModifier.get((Object)slot)) <= 0.99) {
                        minecraft.field_71466_p.func_78276_b(this.toString(v), x, texty, Color.gray.getRGB());
                    }
                    x += 22;
                }
            }

            public String toString(float v) {
                int round = Math.round(v * 100.0f);
                return round + "%";
            }

            public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
            }

            @Nullable
            public List<String> getTooltipStrings(int mouseX, int mouseY) {
                return null;
            }

            public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
                return false;
            }
        }
    }

    public static class Handler
    implements IRecipeHandler<JEIMachineRecipe> {
        static Handler INSTANCE = new Handler();

        @Nonnull
        public Class<JEIMachineRecipe> getRecipeClass() {
            return JEIMachineRecipe.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            throw new IllegalStateException();
        }

        @Nonnull
        public String getRecipeCategoryUid(@Nonnull JEIMachineRecipe recipe) {
            return JEIMachine.getString(recipe.machine);
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull JEIMachineRecipe recipe) {
            return recipe.createWrapper();
        }

        public boolean isRecipeValid(@Nonnull JEIMachineRecipe recipe) {
            return true;
        }
    }
}

