/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fakeplayer;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.fakeplayer.FakeServerHandler;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class XUFakePlayer
extends FakePlayer {
    private static GameProfile XU_PROFILE = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[XU2FakePlayer]");
    @Nullable
    private final GameProfile owner;
    @Nullable
    private final String type;
    private final ItemStack[] cachedHandInventory = new ItemStack[2];
    private final ItemStack[] cachedArmorArray = new ItemStack[4];

    public XUFakePlayer(WorldServer world, GameProfile owner, String type) {
        super(world, XU_PROFILE);
        this.owner = owner;
        this.type = type;
        this.field_71135_a = new FakeServerHandler(this);
        this.func_70105_a(0.0f, 0.0f);
    }

    public void setLocationEdge(BlockPos offset, EnumFacing side) {
        int yaw;
        int pitch;
        double r = 0.2;
        double x = (double)offset.func_177958_n() + 0.5 - (double)side.func_82601_c() * r;
        double y = (double)offset.func_177956_o() + 0.5 - (double)side.func_96559_d() * r;
        double z = (double)offset.func_177952_p() + 0.5 - (double)side.func_82599_e() * r;
        switch (side) {
            case DOWN: {
                pitch = 90;
                yaw = 0;
                break;
            }
            case UP: {
                pitch = -90;
                yaw = 0;
                break;
            }
            case NORTH: {
                yaw = 180;
                pitch = 0;
                break;
            }
            case SOUTH: {
                yaw = 0;
                pitch = 0;
                break;
            }
            case WEST: {
                yaw = 90;
                pitch = 0;
                break;
            }
            case EAST: {
                yaw = 270;
                pitch = 0;
                break;
            }
            default: {
                throw new RuntimeException("Invalid Side (" + side + ")");
            }
        }
        this.func_70012_b(x, y, z, yaw, pitch);
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public RayTraceResult trace(double blockReachDistance) {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        Vec3d vec3d1 = this.getVectorForRotationPublic(this.field_70125_A, this.field_70177_z);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return this.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    @Nonnull
    public Vec3d getVectorForRotationPublic(float rotationPitch, float rotationYaw) {
        return this.func_174806_f(rotationPitch, rotationYaw);
    }

    public void clearInventory() {
        this.field_71071_by.func_174888_l();
    }

    public void func_184598_c(@Nonnull EnumHand hand) {
    }

    public Vec3d getPositionEyes() {
        return new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        TextComponentString itextcomponent = new TextComponentString("[");
        if (this.type != null) {
            itextcomponent.func_150258_a(this.type);
        } else {
            itextcomponent.func_150258_a("XUFakePlayer");
        }
        if (this.owner != null) {
            itextcomponent.func_150258_a(" - ");
            itextcomponent.func_150258_a(this.owner.getName());
        }
        itextcomponent.func_150258_a("]");
        return itextcomponent;
    }

    public void updateCooldown() {
        this.field_184617_aD = 20090;
    }

    public void updateAttributes() {
        block8: for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            ItemStack itemstack;
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    itemstack = this.cachedHandInventory[entityequipmentslot.func_188454_b()];
                    break;
                }
                case ARMOR: {
                    itemstack = this.cachedArmorArray[entityequipmentslot.func_188454_b()];
                    break;
                }
                default: {
                    continue block8;
                }
            }
            ItemStack newStack = this.func_184582_a(entityequipmentslot);
            if (ItemStack.func_77989_b((ItemStack)newStack, (ItemStack)itemstack)) continue;
            if (itemstack != null) {
                this.func_110140_aT().func_111148_a(itemstack.func_111283_C(entityequipmentslot));
            }
            if (newStack != null) {
                this.func_110140_aT().func_111147_b(newStack.func_111283_C(entityequipmentslot));
            }
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    this.cachedHandInventory[entityequipmentslot.func_188454_b()] = newStack == null ? null : newStack.func_77946_l();
                    continue block8;
                }
                case ARMOR: {
                    this.cachedArmorArray[entityequipmentslot.func_188454_b()] = newStack == null ? null : newStack.func_77946_l();
                }
            }
        }
    }
}

