/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonBase;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.utils.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WidgetClickMCButtonChoices<T>
extends WidgetClickMCButtonBase
implements IWidgetServerNetwork {
    public final ArrayList<Choice<T>> choices = new ArrayList();
    int selected = 0;
    int networkState = 0;

    public WidgetClickMCButtonChoices(int x, int y) {
        super(x, y, 18, 18);
    }

    public <V extends WidgetClickMCButtonChoices<T>> V addChoice(T marker, ItemStack stack, String tooltip) {
        int ordinal = this.choices.size();
        Choice<T> choice = new Choice<T>(ordinal, marker, stack, tooltip);
        this.choices.add(choice);
        return (V)this;
    }

    public <V extends WidgetClickMCButtonChoices<T>> V addChoice(T marker, String displayText, String tooltip) {
        int ordinal = this.choices.size();
        Choice<T> choice = new Choice<T>(ordinal, marker, displayText, tooltip);
        this.choices.add(choice);
        this.w = Math.max(this.w, 8 + ExtraUtils2.proxy.apply(DynamicContainer.STRING_WIDTH_FUNCTION, displayText));
        return (V)this;
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        super.renderBackground(manager, gui, guiLeft, guiTop);
        String displayText = this.choices.get((int)this.selected).displayText;
        if (displayText == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.getX() + (this.getW() - gui.getFontRenderer().func_78256_a(displayText)) / 2;
        int col = 0xE0E0E0;
        if (!this.enabled) {
            col = 0xA0A0A0;
        } else if (this.hover) {
            col = 0xFFFFA0;
        }
        gui.getFontRenderer().func_78276_b(displayText, guiLeft + x, guiTop + this.getY() + 4, col);
        manager.func_110577_a(gui.getWidgetTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        gui.renderStack(this.choices.get((int)this.selected).stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
    }

    @Override
    public List<String> getToolTip() {
        String tooltip = this.choices.get((int)this.selected).tooltip;
        return tooltip != null ? ImmutableList.of((Object)Lang.translate(tooltip)) : null;
    }

    @Override
    public PacketBuffer getPacketToSend(int mouseButton) {
        if (mouseButton == 1) {
            --this.selected;
            if (this.selected < 0) {
                this.selected = this.choices.size() - 1;
            }
        } else if (mouseButton == 0) {
            ++this.selected;
            if (this.selected >= this.choices.size()) {
                this.selected = 0;
            }
        } else {
            return null;
        }
        ++this.networkState;
        PacketBuffer buffer = new PacketBuffer();
        buffer.writeInt(this.networkState);
        buffer.writeInt(this.selected);
        return buffer;
    }

    @Override
    public void receiveClientPacket(PacketBuffer buffer) {
        int newState = buffer.readInt();
        int selection = buffer.readInt();
        if (newState > this.networkState) {
            this.networkState = newState;
            this.selected = selection;
            Choice<T> choice = this.choices.get(selection);
            this.onSelectedServer(choice.marker);
        }
    }

    protected abstract void onSelectedServer(T var1);

    public abstract T getSelectedValue();

    @Override
    public void addToDescription(PacketBuffer packet) {
        T value = this.getSelectedValue();
        for (Choice<T> choice : this.choices) {
            if (choice.marker != value) continue;
            this.selected = choice.ordinal;
            break;
        }
        packet.writeInt(this.networkState);
        packet.writeInt(this.selected);
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        int newNetworkState = packet.readInt();
        int newSelected = packet.readInt();
        if (newNetworkState < this.networkState) {
            return;
        }
        this.networkState = newNetworkState;
        this.selected = newSelected;
        if (this.selected < 0 || this.selected >= this.choices.size()) {
            throw new RuntimeException("Invalid packet " + this.selected);
        }
    }

    static class Choice<T> {
        final int ordinal;
        final T marker;
        final ItemStack stack;
        final String tooltip;
        final String displayText;

        public Choice(int ordinal, T marker, String displayText, String tooltip) {
            this.ordinal = ordinal;
            this.marker = marker;
            this.displayText = displayText;
            this.tooltip = tooltip;
            this.stack = null;
        }

        public Choice(int ordinal, T marker, ItemStack stack, String tooltip) {
            this.ordinal = ordinal;
            this.marker = marker;
            this.stack = stack;
            this.tooltip = tooltip;
            this.displayText = null;
        }
    }
}

