/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;

public abstract class WidgetEnergy
extends WidgetBase
implements IWidgetServerNetwork {
    public int level;
    public int currentEnergy;
    public int totalEnergy = -1;

    public WidgetEnergy(int x, int y) {
        super(x, y, 18, 54);
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        int y2 = 54 - this.level;
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 160, 0, 18, y2);
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY() + y2, 178, y2, 18, this.level);
    }

    public abstract int getCurrentEnergy();

    public abstract int getTotalEnergy();

    @Override
    public void addToDescription(PacketBuffer packet) {
        packet.writeInt(this.getCurrentEnergy());
        packet.writeInt(this.getTotalEnergy());
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        this.currentEnergy = packet.readInt();
        this.totalEnergy = packet.readInt();
        if (this.currentEnergy < 0) {
            this.currentEnergy = 0;
        }
        if (this.currentEnergy > this.totalEnergy) {
            this.currentEnergy = this.totalEnergy;
        }
        if (this.totalEnergy < 0) {
            this.totalEnergy = 0;
        }
        this.level = this.totalEnergy == 0 ? 1 : 1 + Math.round((float)this.currentEnergy * 52.0f / (float)this.totalEnergy);
    }

    @Override
    public List<String> getToolTip() {
        if (this.totalEnergy == -1) {
            return null;
        }
        return ImmutableList.of((Object)Lang.translateArgs("%s / %s RF", this.currentEnergy, this.totalEnergy));
    }
}

