/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class SingleStackHandlerBase
implements IItemHandlerModifiable {
    public abstract ItemStack getStack();

    public abstract void setStack(ItemStack var1);

    public void setStackInSlot(int slot, ItemStack stack) {
        if (ItemStack.func_77989_b((ItemStack)this.getStack(), (ItemStack)stack)) {
            return;
        }
        this.setStack(stack);
        this.onContentsChanged();
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        int limit = this.getStackLimit(stack);
        if (limit <= 0) {
            return stack;
        }
        ItemStack curStack = this.getStack();
        if (curStack != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)curStack)) {
                return stack;
            }
            if ((limit -= curStack.field_77994_a) <= 0) {
                return stack;
            }
        }
        boolean reachedLimit = stack.field_77994_a > limit;
        stack = ItemStack.func_77944_b((ItemStack)stack);
        if (!simulate) {
            if (curStack == null) {
                this.setStack(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                curStack.field_77994_a = curStack.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
                this.setStack(curStack);
            }
            this.onContentsChanged();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int toExtract;
        if (amount == 0) {
            return null;
        }
        ItemStack existing = this.getStack();
        if (existing == null) {
            return null;
        }
        int n = toExtract = amount == 1 ? 1 : Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.setStack(null);
                this.onContentsChanged();
            }
            return existing;
        }
        if (!simulate) {
            existing.field_77994_a -= toExtract;
            this.setStack(existing);
            this.onContentsChanged();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected int getStackLimit(ItemStack stack) {
        return stack.func_77976_d();
    }

    protected void onContentsChanged() {
    }

    public boolean canInsertAll(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemStack item = this.insertItem(0, stack, true);
        return item == null;
    }

    public boolean canExtractAll(int amount) {
        ItemStack item = this.extractItem(0, amount, true);
        return item != null && item.field_77994_a == amount;
    }

    public boolean isFull() {
        ItemStack curStack = this.getStack();
        return curStack != null && curStack.field_77994_a >= curStack.func_77976_d();
    }

    public boolean isEmpty() {
        ItemStack curStack = this.getStack();
        return curStack == null || curStack.field_77994_a == 0;
    }

    public int getStackLevel() {
        ItemStack curStack = this.getStack();
        return curStack == null ? 0 : curStack.field_77994_a;
    }
}

