/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StackDump
implements Iterable<ItemStack>,
INBTSerializable<NBTTagList> {
    public final LinkedList<ItemStack> stacks = new LinkedList();

    public void addStack(@Nonnull ItemStack stack) {
        if (stack.field_77994_a == 0) {
            return;
        }
        int maxStackSize = stack.func_77976_d();
        if (maxStackSize > 1) {
            for (ItemStack itemStack : this.stacks) {
                int a;
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)itemStack) || (a = maxStackSize - itemStack.field_77994_a) == 0) continue;
                int min = Math.min(a, stack.field_77994_a);
                itemStack.field_77994_a += min;
                stack.field_77994_a -= min;
                if (stack.field_77994_a != 0) continue;
                return;
            }
        }
        this.stacks.add(stack);
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (ItemStack itemStack : this.stacks) {
            NBTTagCompound nbt = new NBTTagCompound();
            itemStack.func_77955_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.stacks.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_150305_b(i));
            if (stack == null) continue;
            this.stacks.add(stack);
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.stacks.iterator();
    }

    public void attemptDump(IItemHandler contents) {
        ListIterator<ItemStack> iterator = this.stacks.listIterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            ItemStack insert = InventoryHelper.insert(contents, stack, false);
            if (insert != null) {
                iterator.set(insert);
                continue;
            }
            iterator.remove();
        }
    }
}

