/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.api.items.IItemFilter;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerBase;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilterItems
extends XUItemFlatMetadata
implements IItemFilter,
IDynamicHandler {
    public static final int NUM_SLOTS = 9;
    public static final String NBT_KEY_FLAGS = "Flags";

    public ItemFilterItems() {
        super("filter_item");
    }

    public static boolean getFlag(ItemStack filter, FLAG flag) {
        NBTTagCompound nbt = filter.func_77978_p();
        int i = nbt == null ? 0 : nbt.func_74762_e(NBT_KEY_FLAGS);
        return (i & flag.meta) != 0;
    }

    public static void setFlag(ItemStack filter, FLAG flag, boolean value) {
        if (!value && !filter.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(filter);
        int flags = nbt.func_74762_e(NBT_KEY_FLAGS);
        flags = value ? (flags ^= flag.meta) : (flags &= ~flag.meta);
        if (flags == 0) {
            nbt.func_82580_o(NBT_KEY_FLAGS);
            if (nbt.func_82582_d()) {
                filter.func_77982_d(null);
            }
        } else if (flags == (byte)flags) {
            nbt.func_74774_a(NBT_KEY_FLAGS, (byte)flags);
        } else {
            nbt.func_74768_a(NBT_KEY_FLAGS, (int)((byte)flags));
        }
    }

    public static ItemStack getGhostStack(ItemStack filter, int i) {
        NBTTagCompound nbt = filter.func_77978_p();
        String stringDigit = CollectionHelper.STRING_DIGITS[i];
        if (nbt == null || !nbt.func_150297_b(stringDigit, 10)) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(stringDigit));
    }

    public static void putGhostStack(ItemStack filter, int i, ItemStack result) {
        if (result == null && !filter.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(filter);
        String stringDigit = CollectionHelper.STRING_DIGITS[i];
        if (result == null) {
            nbt.func_82580_o(stringDigit);
            if (nbt.func_82582_d()) {
                filter.func_77982_d(null);
            }
        } else {
            NBTTagCompound nbtTagCompound = result.serializeNBT();
            nbt.func_74782_a(stringDigit, (NBTBase)nbtTagCompound);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.func_77973_b() != this || newStack.func_77973_b() != this;
    }

    @Override
    public boolean isItemFilter(@Nonnull ItemStack filterStack) {
        return true;
    }

    @Override
    public boolean matches(@Nonnull ItemStack filterStack, ItemStack target) {
        if (!filterStack.func_77942_o()) {
            return false;
        }
        boolean inverted = ItemFilterItems.getFlag(filterStack, FLAG.INVERTED);
        if (target == null) {
            return inverted;
        }
        boolean useOreDic = ItemFilterItems.getFlag(filterStack, FLAG.USE_ORE_DICTIONARY);
        boolean useMeta = !ItemFilterItems.getFlag(filterStack, FLAG.IGNORE_METADATA);
        boolean useNBT = !ItemFilterItems.getFlag(filterStack, FLAG.IGNORE_NBT);
        for (int i = 0; i < 9; ++i) {
            IItemFilter filter;
            ItemStack ghostStack = ItemFilterItems.getGhostStack(filterStack, i);
            if (ghostStack == null) continue;
            Item item = ghostStack.func_77973_b();
            if (item instanceof IItemFilter && (filter = (IItemFilter)item).matches(ghostStack, target)) {
                return !inverted;
            }
            if (useOreDic) {
                int[] ghostOreIDs = OreDictionary.getOreIDs((ItemStack)ghostStack);
                int[] targetOreIDs = OreDictionary.getOreIDs((ItemStack)ghostStack);
                for (int a : ghostOreIDs) {
                    for (int b : targetOreIDs) {
                        if (a != b) continue;
                        return !inverted;
                    }
                }
            }
            if (item != target.func_77973_b() || useMeta && ghostStack.func_77960_j() != target.func_77960_j() || useNBT && !ItemStack.func_77970_a((ItemStack)ghostStack, (ItemStack)target)) continue;
            return !inverted;
        }
        return inverted;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            this.openItemGui(playerIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (player == null) {
            return null;
        }
        InventoryPlayer inventory = player.field_71071_by;
        int slot = inventory.field_70461_c;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem == null || heldItem.func_77973_b() != this) {
            return null;
        }
        return new FilterConfigContainer(player, slot, heldItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack ghostStack = ItemFilterItems.getGhostStack(stack, i);
            if (ghostStack == null) continue;
            List list = ghostStack.func_82840_a(playerIn, false);
            for (int j = 0; j < list.size(); ++j) {
                String s = (String)list.get(j);
                if (j == 0) {
                    tooltip.add(ChatFormatting.GRAY + CollectionHelper.STRING_DIGITS[1 + i] + " -- " + ChatFormatting.WHITE + s);
                    continue;
                }
                tooltip.add(ChatFormatting.GRAY + "      " + s);
            }
        }
        tooltip.add("");
        for (FLAG flag : FLAG.values()) {
            boolean b = ItemFilterItems.getFlag(stack, flag);
            if (!b) continue;
            tooltip.add(ChatFormatting.BLUE + Lang.translate(flag.name()));
        }
    }

    public class FilterConfigContainer
    extends DynamicContainer {
        private final EntityPlayer player;
        private final int slot;
        private final ItemStack heldItem;

        public FilterConfigContainer(EntityPlayer player, int slot, final ItemStack heldItem) {
            FLAG[] flagValues;
            this.player = player;
            this.slot = slot;
            this.heldItem = heldItem;
            this.addTitle(Lang.getItemName(ItemFilterItems.this), false);
            int i = 0;
            while (i < 9) {
                int slotX = i % 9;
                int slotY = i / 9;
                final int dSlot = i++;
                this.addWidget(new WidgetSlotGhost(new SingleStackHandlerBase(){

                    @Override
                    public ItemStack getStack() {
                        return ItemFilterItems.getGhostStack(heldItem, dSlot);
                    }

                    @Override
                    public void setStack(ItemStack curStack) {
                        ItemFilterItems.putGhostStack(heldItem, dSlot, curStack);
                    }
                }, dSlot, 5 + slotX * 18, 15 + slotY * 18));
            }
            this.crop();
            for (final FLAG flag : flagValues = FLAG.values()) {
                int i2 = flag.ordinal();
                int dx = i2 % 2;
                int dy = i2 / 2;
                int x = 5 + dx * this.width / 2;
                int y = this.height + 4 + dy * 18;
                this.addWidget((IWidget)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<Boolean>(x, y){

                    @Override
                    protected void onSelectedServer(Boolean marker) {
                        ItemFilterItems.setFlag(heldItem, flag, marker);
                    }

                    @Override
                    public Boolean getSelectedValue() {
                        return ItemFilterItems.getFlag(heldItem, flag);
                    }
                }.addChoice(Boolean.valueOf(false), ItemIngredients.Type.SYMBOL_CROSS.newStack(), flag.OFF_KEY)).addChoice((Boolean)true, ItemIngredients.Type.SYMBOL_TICK.newStack(), flag.ON_KEY));
                this.addWidget(new WidgetText(x + 20, y + 4, Lang.translate(flag.name())));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            ItemStack heldItem;
            return playerIn == this.player && this.player.field_71071_by.field_70461_c == this.slot && (heldItem = playerIn.func_184614_ca()) != null && heldItem.func_77973_b() == ItemFilterItems.this;
        }

        @Override
        public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
            return super.func_82846_b(par1EntityPlayer, par2);
        }
    }

    static enum FLAG {
        INVERTED,
        IGNORE_NBT,
        IGNORE_METADATA,
        USE_ORE_DICTIONARY;

        public final int meta = 1 << this.ordinal();
        public final String ON_KEY = this.name() + " ON";
        public final String OFF_KEY = this.name() + " OFF";
    }
}

