/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileMachineProvider
extends TileMachine
implements IEnergyProvider {
    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public void process() {
        this.sendEnergy();
        if (!this.active) {
            this.setInactive();
            return;
        }
        if (this.totalTime > 0) {
            int n = 1 + this.upgrades.getLevel(Upgrade.SPEED);
            int energyAtTime1 = (int)((float)this.energyOutput * (float)this.processTime / (float)this.totalTime);
            int energyAtTime2 = (int)((float)this.energyOutput * (float)Math.min(this.totalTime, this.processTime + n) / (float)this.totalTime);
            if (!this.processEnergy(energyAtTime2 - energyAtTime1)) {
                this.setInactive();
                return;
            }
            this.setActive();
            this.processTime += n;
            if (this.processTime >= this.totalTime) {
                this.processTime = 0;
                this.totalTime = 0;
                this.energyOutput = 0;
            }
        } else {
            this.processRecipeInput();
            if (this.curRecipe == null) {
                this.setInactive();
                return;
            }
            this.totalTime = this.curRecipe.getProcessingTime(this.itemInputMap, this.fluidInputMap);
            this.energyOutput = this.curRecipe.getEnergyOutput(this.itemInputMap, this.fluidInputMap);
            this.processTime = 0;
            if (this.totalTime == 0 && !this.processEnergy(this.energyOutput)) {
                this.setInactive();
                return;
            }
            this.setActive();
            this.consumeInputs();
        }
    }

    public void sendEnergy() {
        int energy;
        EnumFacing facing;
        IEnergyReceiver receiver;
        if (this.storage.getEnergyStored() <= 0) {
            return;
        }
        int maxSend = Math.min(80 * (1 + this.upgrades.getLevel(Upgrade.SPEED)), this.storage.getEnergyStored());
        IEnergyReceiver[] receivers = new IEnergyReceiver[6];
        int n = 0;
        EnumFacing[] facingValues = EnumFacing.values();
        for (int i = 0; i < 6; ++i) {
            IEnergyReceiver receiver2;
            EnumFacing facing2 = facingValues[i];
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing2));
            if (!(tileEntity instanceof IEnergyReceiver) || !(receiver2 = (IEnergyReceiver)tileEntity).canConnectEnergy(facing2.func_176734_d())) continue;
            receivers[i] = receiver2;
            ++n;
        }
        if (n == 0) {
            return;
        }
        int toSend = maxSend / n;
        if (toSend > 0) {
            for (int i = 0; i < 6; ++i) {
                receiver = receivers[i];
                if (receiver == null) continue;
                facing = facingValues[i];
                energy = receiver.receiveEnergy(facing.func_176734_d(), toSend, false);
                maxSend -= energy;
                this.storage.modifyEnergyStored(-energy);
            }
        }
        if (maxSend == 0) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            receiver = receivers[i];
            if (receiver == null) continue;
            facing = facingValues[i];
            energy = receiver.receiveEnergy(facing.func_176734_d(), maxSend, false);
            this.storage.modifyEnergyStored(-energy);
            if ((maxSend -= energy) != 0) continue;
            return;
        }
    }

    protected boolean processEnergy(int amount) {
        if (this.storage.receiveEnergy(amount, true) != amount) {
            return false;
        }
        this.storage.receiveEnergy(amount, false);
        return true;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74768_a("TotalTime", this.totalTime);
        nbt.func_74768_a("EnergyOutput", this.energyOutput);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.totalTime = nbt.func_74762_e("TotalTime");
        this.energyOutput = nbt.func_74762_e("EnergyOutput");
    }
}

