/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import cofh.api.energy.IEnergyReceiver;
import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import net.minecraft.util.EnumFacing;

public class TileMachineReceiver
extends TileMachine
implements IEnergyReceiver {
    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public void process() {
        boolean success;
        if (!this.active) {
            this.setInactive();
            return;
        }
        this.processRecipeInput();
        if (this.curRecipe == null) {
            this.setInactive();
            return;
        }
        this.totalTime = this.curRecipe.getProcessingTime(this.itemInputMap, this.fluidInputMap);
        this.energyOutput = this.curRecipe.getEnergyOutput(this.itemInputMap, this.fluidInputMap);
        int n = 1 + this.upgrades.getLevel(Upgrade.SPEED);
        if (this.totalTime <= 0) {
            success = this.processEnergy(this.energyOutput);
        } else {
            int energyAtTime1 = (int)((float)this.energyOutput * (float)this.processTime / (float)this.totalTime);
            int energyAtTime2 = (int)((float)this.energyOutput * (float)Math.min(this.totalTime, this.processTime + n) / (float)this.totalTime);
            success = this.processEnergy(energyAtTime2 - energyAtTime1);
        }
        if (!success) {
            this.setInactive();
            return;
        }
        this.setActive();
        this.processTime += n;
        if (this.processTime >= this.totalTime) {
            this.processTime = 0;
            this.consumeInputs();
        }
    }

    protected boolean processEnergy(int amount) {
        if (this.storage.extractEnergy(amount, true) != amount) {
            return false;
        }
        this.storage.extractEnergy(amount, false);
        return true;
    }
}

