/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.player;

import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class PlayerPower
implements IPower,
IWorldPowerMultiplier {
    public final int freq;
    @Nonnull
    private final EntityPlayer player;
    public int cooldown = 20;
    public final int dimension;
    public boolean invalid;

    @Override
    public boolean isLoaded() {
        return true;
    }

    public PlayerPower(@Nonnull EntityPlayer player) {
        this.player = player;
        this.freq = player instanceof EntityPlayerMP ? Freq.getBasePlayerFreq((EntityPlayerMP)player) : 0;
        this.dimension = player.field_70170_p.field_73011_w.getDimension();
    }

    @Override
    public IWorldPowerMultiplier getMultiplier() {
        return this;
    }

    @Override
    public int frequency() {
        return this.freq;
    }

    @Override
    public World world() {
        return null;
    }

    @Override
    public float multiplier(World world) {
        EntityPlayerMP playerMP = this.getPlayerMP();
        if (this.invalid || !FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().contains(playerMP)) {
            return 0.0f;
        }
        return this.power((EntityPlayer)playerMP);
    }

    @Nonnull
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Nonnull
    public EntityPlayerMP getPlayerMP() {
        return (EntityPlayerMP)this.player;
    }

    public abstract float power(EntityPlayer var1);

    @Override
    public final float getPower() {
        return 1.0f;
    }

    public void onAdd() {
    }

    public void onRemove() {
    }

    public void update(boolean selected, ItemStack params) {
    }

    public void tick() {
    }

    public void onAddClient() {
    }

    public void onRemoveClient() {
    }

    public void tickClient() {
    }

    public void updateClient(boolean selected, ItemStack params) {
    }

    @Override
    @Nullable
    public BlockPos getLocation() {
        return null;
    }
}

