/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.RecipeBuilder;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class GenericMachineRecipe
implements IMachineRecipe {
    protected final Machine machine;
    protected final Map<MachineSlotItem, List<ItemStack>> inputItemStackMap;
    protected final Map<MachineSlotFluid, List<FluidStack>> inputFluidStackMap;
    protected final Map<MachineSlotItem, List<ItemStack>> outputItemStackMap;
    protected final boolean hasMultipleOutputs;
    protected final Map<MachineSlotFluid, FluidStack> outputFluidStackMap;
    protected final TObjectIntMap<MachineSlot> inputAmountMap;
    protected final TObjectIntMap<MachineSlot> outputAmountMap;
    protected final int energyOutput;
    protected final int processingTime;
    protected final TObjectFloatHashMap<MachineSlot> outputProbabilities;

    public GenericMachineRecipe(Machine machine, Map<MachineSlotItem, List<ItemStack>> inputItemStackMap, Map<MachineSlotFluid, List<FluidStack>> inputFluidStackMap, Map<MachineSlotItem, List<ItemStack>> outputItemStackMap, Map<MachineSlotFluid, FluidStack> outputFluidStackMap, TObjectIntMap<MachineSlot> inputAmountMap, TObjectIntMap<MachineSlot> outputAmountMap, int processingTime, int energyOutput, TObjectFloatHashMap<MachineSlot> outputProbabilities) {
        this.machine = machine;
        this.inputItemStackMap = ImmutableMap.copyOf(inputItemStackMap);
        this.inputFluidStackMap = ImmutableMap.copyOf(inputFluidStackMap);
        this.outputItemStackMap = ImmutableMap.copyOf(outputItemStackMap);
        this.outputFluidStackMap = ImmutableMap.copyOf(outputFluidStackMap);
        this.outputAmountMap = outputAmountMap;
        this.processingTime = processingTime;
        this.energyOutput = energyOutput;
        this.inputAmountMap = inputAmountMap;
        this.hasMultipleOutputs = !outputItemStackMap.values().stream().allMatch(itemStacks -> itemStacks.size() <= 1 && itemStacks instanceof ImmutableList);
        this.outputProbabilities = outputProbabilities;
    }

    @Override
    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, FluidStack>>> getJEIInputItemExamples() {
        if (this.inputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty())) {
            return ImmutableList.of();
        }
        if (this.outputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty())) {
            return ImmutableList.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.inputFluidStackMap.forEach((machineSlotFluid, fluidStacks) -> builder.put(machineSlotFluid, fluidStacks.stream().findAny().orElse(null)));
        return ImmutableList.of((Object)Pair.of((Object)ImmutableMap.copyOf(this.inputItemStackMap), (Object)builder.build()));
    }

    @Override
    public boolean allowInputItem(MachineSlotItem slot, ItemStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        if (this.outputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty())) {
            return false;
        }
        return this.matchesSlotItem(slot, stack) && this.checkExistingItems(existingItems, existingFluids);
    }

    public boolean checkExistingItems(Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        for (Map.Entry<MachineSlotItem, ItemStack> entry : existingItems.entrySet()) {
            if (this.matchesSlotItem(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<MachineSlot, Object> entry : existingFluids.entrySet()) {
            if (this.matchesSlotFluid((MachineSlotFluid)entry.getKey(), (FluidStack)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matchesSlotItem(MachineSlotItem slot, ItemStack stack) {
        for (ItemStack itemStack : this.inputItemStackMap.get(slot)) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)itemStack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowInputFluid(MachineSlotFluid slot, FluidStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.matchesSlotFluid(slot, stack) && this.checkExistingItems(existingItems, existingFluids);
    }

    public boolean matchesSlotFluid(MachineSlotFluid slot, FluidStack stack) {
        for (FluidStack fluidStack : this.inputFluidStackMap.get(slot)) {
            if (!fluidStack.isFluidEqual(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack;
        if (this.outputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty())) {
            return false;
        }
        for (MachineSlotItem slotItem : this.machine.itemInputs) {
            stack = inputItems.get(slotItem);
            if (!(stack == null ? !slotItem.optional : !this.matchesSlotItem(slotItem, stack) || this.inputAmountMap.get((Object)slotItem) > stack.field_77994_a)) continue;
            return false;
        }
        for (MachineSlotFluid slotFluid : this.machine.fluidOutputs) {
            stack = inputFluids.get(slotFluid);
            if (!(stack == null ? !slotFluid.optional : !this.matchesSlotFluid(slotFluid, (FluidStack)stack) || this.inputAmountMap.get((Object)slotFluid) > stack.amount)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotItem, ItemStack> map = new HashMap<MachineSlotItem, ItemStack>();
        if (this.hasMultipleOutputs) {
            Set mods = inputItems.values().stream().filter(stack -> stack != null).map(stack -> stack.func_77973_b().getRegistryName().func_110624_b()).collect(Collectors.toSet());
            this.outputItemStackMap.forEach((machineSlotItem, itemStacks) -> {
                int size = this.outputAmountMap.get(machineSlotItem);
                if (size < 0) {
                    size = 0;
                }
                ItemStack bestStack = null;
                if (size > 0) {
                    for (ItemStack stack : itemStacks) {
                        if (bestStack == null) {
                            bestStack = stack;
                            continue;
                        }
                        String resourceDomain = stack.func_77973_b().getRegistryName().func_110624_b();
                        if (!"minecraft".equals(resourceDomain) && !mods.contains(resourceDomain)) continue;
                        bestStack = stack;
                        break;
                    }
                }
                map.put((MachineSlotItem)machineSlotItem, this.makeSafe(ItemHandlerHelper.copyStackWithSize(bestStack, (int)size)));
            });
        } else {
            this.outputItemStackMap.forEach((machineSlotItem, stack) -> {
                int size = this.outputAmountMap.get(machineSlotItem);
                if (size < 0) {
                    size = 0;
                }
                map.put((MachineSlotItem)machineSlotItem, this.makeSafe(ItemHandlerHelper.copyStackWithSize((ItemStack)stack.stream().findAny().orElse(null), (int)size)));
            });
        }
        return map;
    }

    private ItemStack makeSafe(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        return stack;
    }

    @Override
    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotFluid, FluidStack> map = new HashMap<MachineSlotFluid, FluidStack>();
        this.outputFluidStackMap.forEach((machineSlotFluid, stack) -> map.put((MachineSlotFluid)machineSlotFluid, stack != null ? stack.copy() : null));
        return map;
    }

    @Override
    public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.energyOutput;
    }

    @Override
    public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.processingTime;
    }

    @Override
    public TObjectIntMap<MachineSlot> getAmountToConsume(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.inputAmountMap;
    }

    @Override
    @Nullable
    public TObjectFloatMap<MachineSlot> getProbabilityModifier(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.outputProbabilities;
    }

    public static class Builder
    implements RecipeBuilder {
        protected final HashMap<MachineSlotItem, List<ItemStack>> inputItemStackMap = new HashMap();
        protected final HashMap<MachineSlotFluid, List<FluidStack>> inputFluidStackMap = new HashMap();
        protected final HashMap<MachineSlotItem, List<ItemStack>> outputItemStackMap = new HashMap();
        protected final HashMap<MachineSlotFluid, FluidStack> outputFluidStackMap = new HashMap();
        protected final TObjectIntHashMap<MachineSlot> inputAmountMap = new TObjectIntHashMap();
        protected final Machine machine;
        protected final TObjectIntMap<MachineSlot> outputAmountMap = new TObjectIntHashMap();
        protected int energy = 0;
        protected int processingTime = 200;
        TObjectFloatHashMap<MachineSlot> outputProbabilities = null;

        public Builder(Machine machine) {
            this.machine = machine;
        }

        @Override
        public RecipeBuilder setEnergy(int amount) {
            Validate.isTrue((amount >= 0 ? 1 : 0) != 0);
            this.energy = amount;
            return this;
        }

        @Override
        public RecipeBuilder setProcessingTime(int time) {
            Validate.isTrue((time > 0 ? 1 : 0) != 0, (String)"Negative/Zero processing times are not allowed %s", (long)time);
            this.processingTime = time;
            return this;
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull ItemStack input) {
            return this.setItemInput(slot, input, input.field_77994_a);
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull ItemStack input, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputItemStackMap.put(slot, (List<ItemStack>)ImmutableList.of((Object)input.func_77946_l()));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull String string, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputItemStackMap.put(slot, OreDictionary.getOres((String)string));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull List<ItemStack> stacks, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputItemStackMap.put(slot, stacks);
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem slot, ItemStack stack) {
            if (stack != null) {
                this.outputItemStackMap.put(slot, (List<ItemStack>)ImmutableList.of((Object)stack));
                this.outputAmountMap.put((Object)slot, stack.field_77994_a);
            } else {
                this.outputAmountMap.put((Object)slot, 0);
            }
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem slot, @Nonnull String oreName, int amount) {
            this.outputItemStackMap.put(slot, OreDictionary.getOres((String)oreName));
            this.outputAmountMap.put((Object)slot, amount);
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem slot, @Nonnull List<ItemStack> ores, int amount) {
            this.outputItemStackMap.put(slot, ores);
            this.outputAmountMap.put((Object)slot, amount);
            return this;
        }

        @Override
        public RecipeBuilder setFluidInputFluidStack(@Nonnull MachineSlotFluid slot, @Nonnull FluidStack input) {
            return this.setFluidInputFluidStack(slot, input, input.amount);
        }

        @Override
        public RecipeBuilder setFluidInputFluidStack(@Nonnull MachineSlotFluid slot, @Nonnull FluidStack input, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputFluidStackMap.put(slot, (List<FluidStack>)ImmutableList.of((Object)input.copy()));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setFluidInputList(@Nonnull MachineSlotFluid slot, @Nonnull List<FluidStack> stacks, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputFluidStackMap.put(slot, stacks);
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid slot, FluidStack stack) {
            this.outputFluidStackMap.put(slot, stack);
            return this;
        }

        @Override
        public RecipeBuilder setProbability(@Nonnull MachineSlot outputSlot, float probability) {
            if (this.outputProbabilities == null) {
                this.outputProbabilities = new TObjectFloatHashMap();
            }
            this.outputProbabilities.put((Object)outputSlot, probability);
            return this;
        }

        @Override
        public IMachineRecipe build() {
            for (MachineSlotItem slotItem : this.machine.itemInputs) {
                if (slotItem.optional) continue;
                Validate.isTrue((boolean)this.inputItemStackMap.containsKey(slotItem), (String)"Slot %s has no input", (Object[])new Object[]{slotItem});
                Validate.isTrue((boolean)this.inputAmountMap.containsKey((Object)slotItem), (String)"Slot %s was not assigned an amount", (Object[])new Object[]{slotItem});
            }
            for (MachineSlotFluid slotFluid : this.machine.fluidInputs) {
                if (slotFluid.optional) continue;
                Validate.isTrue((boolean)this.inputFluidStackMap.containsKey(slotFluid), (String)"Slot %s has no input", (Object[])new Object[]{slotFluid});
                Validate.isTrue((boolean)this.inputAmountMap.containsKey((Object)slotFluid), (String)"Slot %s was not assigned an amount", (Object[])new Object[]{slotFluid});
            }
            for (MachineSlotItem slotItem : this.machine.itemOutputs) {
                if (slotItem.optional) continue;
                Validate.isTrue((boolean)this.outputItemStackMap.containsKey(slotItem), (String)"Slot %s has no output", (Object[])new Object[]{slotItem});
            }
            for (MachineSlotFluid slotFluid : this.machine.fluidOutputs) {
                if (slotFluid.optional) continue;
                Validate.isTrue((boolean)this.outputFluidStackMap.containsKey(slotFluid), (String)"Slot %s has no output", (Object[])new Object[]{slotFluid});
            }
            return this.getGenericMachineRecipe(this.machine, this.inputItemStackMap, this.inputFluidStackMap, this.outputItemStackMap, this.outputFluidStackMap, this.inputAmountMap, this.processingTime, this.energy, this.outputAmountMap);
        }

        @Nonnull
        protected GenericMachineRecipe getGenericMachineRecipe(Machine machine, HashMap<MachineSlotItem, List<ItemStack>> inputItemStackMap, HashMap<MachineSlotFluid, List<FluidStack>> inputFluidStackMap, Map<MachineSlotItem, List<ItemStack>> outputItemStackMap, HashMap<MachineSlotFluid, FluidStack> outputFluidStackMap, TObjectIntHashMap<MachineSlot> amount, int processingTime, int energyOutput, TObjectIntMap<MachineSlot> outputAmountMap) {
            return new GenericMachineRecipe(machine, (Map<MachineSlotItem, List<ItemStack>>)inputItemStackMap, (Map<MachineSlotFluid, List<FluidStack>>)inputFluidStackMap, outputItemStackMap, (Map<MachineSlotFluid, FluidStack>)outputFluidStackMap, (TObjectIntMap<MachineSlot>)amount, outputAmountMap, processingTime, energyOutput, this.outputProbabilities);
        }
    }
}

