/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.fluids.FluidTankSerial;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.Lang;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class TileDrum
extends XUTile {
    public static int numTicksTilDisplayEmpty = 40;
    public FluidStack prevFluid = null;
    boolean recentlyFilled = false;
    boolean recentlyDrained = false;
    public FluidTankSerial tanks = this.registerNBT("tank", new FluidTankSerial(this.getCapacity()){

        @Override
        protected void onChange() {
            TileDrum.this.func_70296_d();
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            boolean t2 = this.getFluid() == null;
            int t = super.fill(resource, doFill);
            if (doFill) {
                if (t2 && this.getFluid() != null && !this.getFluid().isFluidEqual(TileDrum.this.prevFluid)) {
                    TileDrum.this.prevFluid = this.getFluid().copy();
                    TileDrum.this.markForUpdate();
                }
                if (t != 0) {
                    TileDrum.this.recentlyFilled = true;
                }
            }
            return t;
        }

        @Override
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || !resource.isFluidEqual(this.getFluid())) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        @Override
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack t = super.drain(maxDrain, doDrain);
            if (doDrain && t != null && this.getFluidAmount() == 0) {
                TileDrum.this.recentlyDrained = true;
                TileDrum.this.scheduleUpdate();
            }
            return t;
        }
    });

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Fluid")) {
            return null;
        }
        NBTTagCompound fluidNBT = tagCompound.func_74775_l("Fluid");
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNBT);
    }

    protected abstract int getCapacity();

    public void ticked() {
        if (this.recentlyDrained) {
            this.recentlyDrained = false;
            if (this.recentlyFilled) {
                this.recentlyFilled = false;
                this.scheduleUpdate();
            } else {
                this.func_70296_d();
                this.markForUpdate();
            }
        }
    }

    public void scheduleUpdate() {
        this.field_145850_b.func_180497_b(this.func_174877_v(), this.func_145838_q(), numTicksTilDisplayEmpty, 0);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)heldItem);
        if (container == null) {
            playerIn.func_146105_b((ITextComponent)Lang.chat("Tank: %s / %s", this.tanks.getFluidAmount(), this.getCapacity()));
            return true;
        }
        if (this.attemptDrain(playerIn, hand, heldItem, container)) {
            return true;
        }
        if (this.attemptFill(playerIn, hand, heldItem, container)) {
            return true;
        }
        return true;
    }

    public boolean attemptFill(EntityPlayer playerIn, EnumHand hand, ItemStack mutable, IFluidHandler container) {
        FluidStack drain = this.tanks.drain(1000, false);
        int fill = container.fill(drain, false);
        if (fill > 0) {
            this.tanks.drain(fill, true);
            fill = container.fill(drain, true);
            this.markForUpdate();
        }
        playerIn.func_184611_a(hand, mutable);
        return fill > 0;
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        FluidStack oldFluid;
        FluidStack fluid = packet.readFluidStack();
        if (!(fluid == (oldFluid = this.tanks.getFluid()) || fluid != null && fluid.isFluidEqual(oldFluid))) {
            this.markForUpdate();
        }
        this.tanks.setFluid(fluid);
    }

    @Override
    public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
        if (this.tanks.isEmpty()) {
            return false;
        }
        ItemStack itemStack = this.createDropStack((XUBlockState)state);
        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
        return true;
    }

    @Override
    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        return Optional.of(this.createDropStack(this.getBlockState()));
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        FluidStack fluidStack = TileDrum.getFluidFromItemStack(stack);
        if (fluidStack != null && fluidStack.amount > this.getCapacity()) {
            fluidStack.amount = this.getCapacity();
        }
        this.tanks.setFluid(fluidStack);
    }

    public boolean restrictNBTCopy() {
        return true;
    }

    public ItemStack createDropStack(XUBlockState blockState) {
        int meta = blockState.dropMeta;
        ItemStack itemStack = new ItemStack(blockState.func_177230_c(), 1, meta);
        NBTTagCompound nbt = this.tanks.serializeNBT();
        itemStack.func_77983_a("Fluid", (NBTBase)nbt);
        return itemStack;
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        FluidStack fluid = this.tanks.getFluid();
        if (fluid != null) {
            fluid = fluid.copy();
            fluid.amount = 1;
        }
        packet.writeFluidStack(fluid);
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.tanks;
    }

    protected boolean attemptDrain(EntityPlayer playerIn, EnumHand hand, ItemStack mutable, IFluidHandler container) {
        FluidStack toDrain = container.drain(1000, false);
        if (toDrain == null) {
            return false;
        }
        int fill = this.tanks.fill(toDrain, false);
        if (fill > 0) {
            FluidStack drain = container.drain(fill, true);
            fill = this.tanks.fill(drain, true);
            this.markForUpdate();
        }
        playerIn.func_184611_a(hand, mutable);
        return fill > 0;
    }

    public int getComparatorLevel() {
        int amount = this.tanks.getFluidAmount();
        if (amount == 0) {
            return 0;
        }
        return 1 + amount * 14 / this.tanks.getCapacity();
    }

    public static class TankInf
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 10000000;
        }

        @Override
        public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
            if (heldItem == null) {
                return false;
            }
            IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)heldItem);
            if (container == null) {
                return false;
            }
            if (worldIn.field_72995_K) {
                return true;
            }
            if (this.tanks.getFluidAmount() == 0) {
                if (playerIn.field_71075_bZ.field_75098_d) {
                    FluidStack fluid = container.drain(Integer.MAX_VALUE, false);
                    if (fluid == null) {
                        return true;
                    }
                    this.tanks.setFluid(fluid.copy());
                    this.markForUpdate();
                    this.func_70296_d();
                }
                return true;
            }
            if (this.attemptFill(playerIn, hand, heldItem, container)) {
                return true;
            }
            return true;
        }

        @Override
        @Nullable
        public IFluidHandler getFluidHandler(EnumFacing facing) {
            return new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return tanks.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null) {
                        return null;
                    }
                    return this.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    FluidStack fluid = tanks.getFluid();
                    if (fluid == null) {
                        return null;
                    }
                    FluidStack copy = fluid.copy();
                    copy.amount = maxDrain;
                    return copy;
                }
            };
        }
    }

    public static class Tank65536
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 65536000;
        }
    }

    public static class Tank4096
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 4096000;
        }
    }

    public static class Tank256
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 256000;
        }
    }

    public static class Tank16
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 16000;
        }
    }
}

