/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.MultiBlockStateBuilder;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.helpers.ItemStackHelper;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BlockTransferPipe
extends XUBlockStatic
implements IPipe {
    public static final Map<EnumFacing, IProperty<Boolean>> SIDE_BLOCKED = XUBlockStateCreator.createDirectionBooleanMap("blocked", (name, side) -> PropertyBool.func_177716_a((String)name));
    public static MultiBlockStateBuilder<BlockTransferPipe> stateBuilder = new MultiBlockStateBuilder<BlockTransferPipe>(BlockTransferPipe.class, new Object[0]).addWorldProperties(SIDE_BLOCKED.values());
    EnumMap<EnumFacing, HashSet<IBlockState>> canOutputPipeStates;
    IBlockState defaultSimple;
    IBlockState allSides;

    public BlockTransferPipe() {
        super(Material.field_151571_B, MapColor.field_151665_m);
    }

    public static boolean isUnblocked(@Nonnull IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b(SIDE_BLOCKED.get(facing)) == false;
    }

    public static boolean shouldConnectPipe(IBlockAccess world, BlockPos pos, EnumFacing facing, IPipe pipe) {
        BlockPos offset = pos.func_177972_a(facing);
        IPipe otherPipe = TransferHelper.getPipe(world, offset);
        return otherPipe != null && (pipe.canOutput(world, pos, facing) && otherPipe.canInput(world, offset, facing.func_176734_d()) || pipe.canInput(world, pos, facing) && otherPipe.canOutput(world, offset, facing.func_176734_d()));
    }

    public static boolean shouldConnectTile(IBlockAccess world, BlockPos pos, EnumFacing facing, IPipe pipe) {
        BlockPos offset = pos.func_177972_a(facing);
        if (pipe.canOutputTile(world, pos, facing) && TransferHelper.getPipe(world, offset) == null) {
            for (CapGetter<?> cap : CapGetter.caps) {
                if (!pipe.hasCapability(world, pos, facing, cap)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isToolEffective(String type, @Nonnull IBlockState state) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return true;
    }

    @Override
    public void setBlockState(XUBlockStateCreator creator) {
        super.setBlockState(creator);
        if (!BlockTransferPipe.stateBuilder.initialized) {
            return;
        }
        this.defaultSimple = this.allSides = BlockTransferPipe.stateBuilder.defaultState;
        for (IProperty<Boolean> propertyBool : SIDE_BLOCKED.values()) {
            this.allSides = this.allSides.func_177226_a(propertyBool, (Comparable)Boolean.valueOf(true));
            this.defaultSimple = this.defaultSimple.func_177226_a(propertyBool, (Comparable)Boolean.valueOf(false));
        }
        this.canOutputPipeStates = new EnumMap(EnumFacing.class);
        for (EnumFacing a : EnumFacing.values()) {
            HashSet<IBlockState> set = new HashSet<IBlockState>();
            for (IBlockState genericPipeState : BlockTransferPipe.stateBuilder.genericPipeStates) {
                if (!BlockTransferPipe.isUnblocked(genericPipeState, a.func_176734_d())) continue;
                set.add(genericPipeState);
            }
            this.canOutputPipeStates.put(a, set);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!ItemStackHelper.holdingWrench(playerIn)) {
            return false;
        }
        EnumFacing facing = EnumFacing.func_176737_a((float)(hitX - 0.5f), (float)(hitY - 0.5f), (float)(hitZ - 0.5f));
        BlockPos offset = pos.func_177972_a(facing);
        if (!TransferHelper.isInputtingPipe((IBlockAccess)worldIn, offset, facing.func_176734_d()) && !TransferHelper.hasValidCapability((IBlockAccess)worldIn, offset, facing.func_176734_d())) {
            return false;
        }
        IBlockState newState = state.func_177231_a(SIDE_BLOCKED.get(facing));
        worldIn.func_175656_a(pos, newState);
        return true;
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model = new BoxModel();
        model.addBoxI(6, 6, 6, 10, 10, 10, "transfernodes/pipes");
        for (EnumFacing facing : EnumFacing.values()) {
            if (!BlockTransferPipe.isUnblocked(state, facing)) continue;
            model.addBoxI((int)6, (int)0, (int)6, (int)10, (int)6, (int)10, (String)"transfernodes/pipes").rotateToSide((EnumFacing)facing).tint = facing.ordinal();
        }
        return model;
    }

    @Override
    public void registerTextures() {
        super.registerTextures();
        Textures.register("transfernodes/pipes_oneway", "transfernodes/pipes_nozzle");
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        IPipe pipe;
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        if ((pipe = TransferHelper.getPipe(world, pos)) == null) {
            return super.getWorldModel(world, pos, state);
        }
        BoxModel model = new BoxModel();
        Box center_box = model.addBoxI(6, 6, 6, 10, 10, 10, "transfernodes/pipes");
        for (EnumFacing facing : EnumFacing.values()) {
            if (BlockTransferPipe.shouldConnectPipe(world, pos, facing, pipe)) {
                boolean value = pipe.canOutput(world, pos, facing);
                Box box = value ? model.addBoxI(6, 0, 6, 10, 6, 10, "transfernodes/pipes") : model.addBoxI(6, 0, 6, 10, 6, 10, "transfernodes/pipes_oneway");
                box.setTint(facing.ordinal());
                box.rotateToSide(facing).setInvisible(facing, facing.func_176734_d());
                center_box.setInvisible(facing);
                continue;
            }
            if (!BlockTransferPipe.shouldConnectTile(world, pos, facing, pipe)) continue;
            model.addBoxI(6, 0, 6, 10, 6, 10, "transfernodes/pipes").rotateToSide(facing).setTint(facing.ordinal()).setInvisible(facing, facing.func_176734_d());
            if (!pipe.shouldTileConnectionShowNozzle(world, pos, facing)) continue;
            model.addBoxI(5, 0, 5, 11, 3, 11, "transfernodes/pipes_nozzle").rotateToSide(facing).setTint(facing.ordinal());
        }
        return model;
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return (BoxModel)this.cachedInvModels.get(this.xuBlockState.getStateFromItemStack(item));
    }

    @Override
    public boolean canInput(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return true;
    }

    @Override
    public boolean canOutput(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return BlockTransferPipe.isUnblocked(world.func_180495_p(pos), dir);
    }

    @Override
    public boolean canOutputTile(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return BlockTransferPipe.isUnblocked(world.func_180495_p(pos), dir);
    }

    @Override
    public <T> boolean hasCapability(IBlockAccess world, BlockPos pos, EnumFacing side, CapGetter<T> capability) {
        if (!BlockTransferPipe.isUnblocked(world.func_180495_p(pos), side)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        return tileEntity != null && capability.hasInterface((ICapabilityProvider)tileEntity, side.func_176734_d());
    }

    @Override
    public <T> T getCapability(IBlockAccess world, BlockPos pos, EnumFacing side, CapGetter<T> capability) {
        if (!BlockTransferPipe.isUnblocked(world.func_180495_p(pos), side)) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        if (tileEntity != null) {
            return capability.getInterface((ICapabilityProvider)tileEntity, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean shouldTileConnectionShowNozzle(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    @Nonnull
    public String func_149739_a() {
        return "tile.ExtraUtils2:pipe";
    }
}

