/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TransferNodeBase;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransferNodeItem
extends TransferNodeBase<IItemHandler>
implements IDynamicHandler {
    protected SingleStackHandlerFilter.ItemFilter filter = this.registerNBT("Filter", new SingleStackHandlerFilter.ItemFilter(){

        @Override
        protected void onContentsChanged() {
            TransferNodeItem.this.holder.func_70296_d();
        }
    });
    protected SingleStackHandler stack = this.registerNBT("Buffer", new SingleStackHandler(){

        @Override
        protected int getStackLimit(ItemStack stack) {
            if (!TransferNodeItem.this.filter.matches(stack)) {
                return 0;
            }
            return stack.func_77976_d();
        }

        @Override
        protected void onContentsChanged() {
            TransferNodeItem.this.holder.func_70296_d();
        }
    });

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getBaseDrop());
        if (!this.stack.isEmpty()) {
            drops.add(this.stack.getStack());
        }
        for (ItemStack itemStack : InventoryHelper.getItemHandlerIterator((IItemHandler)this.upgradeHandler)) {
            if (itemStack == null) continue;
            drops.add(itemStack);
        }
        return drops;
    }

    @Override
    protected boolean shouldAdvance() {
        return !this.stack.isEmpty();
    }

    @Override
    protected void processBuffer(IItemHandler attached) {
        block6: {
            block5: {
                BlockPos offset;
                if (attached != null) break block5;
                int upgradeLevel = this.getUpgradeLevel(Upgrade.MINING);
                if (upgradeLevel <= 0) break block6;
                if (this.stack.isFull()) {
                    return;
                }
                ItemStack b = new ItemStack(Blocks.field_150347_e, upgradeLevel);
                if (!this.stack.isEmpty() && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack.getStack(), (ItemStack)b)) {
                    return;
                }
                World world = this.holder.func_145831_w();
                IBlockState state = world.func_180495_p(offset = this.holder.func_174877_v().func_177972_a(this.side));
                if (state != BlockStates.cobblestone) break block6;
                boolean lava = false;
                boolean water = false;
                EnumSet<EnumFacing> enumFacings = FacingHelper.horizontalOrthogonal.get(this.side);
                for (EnumFacing facing : enumFacings) {
                    IBlockState blockState = world.func_180495_p(offset.func_177972_a(facing));
                    if (blockState == BlockStates.lava_level_0) {
                        lava = true;
                        continue;
                    }
                    if (blockState != BlockStates.water_level_0) continue;
                    water = true;
                }
                if (!water || !lava) break block6;
                this.stack.insertItem(0, b, false);
                break block6;
            }
            for (int i = 0; i < attached.getSlots() && !this.stack.isFull(); ++i) {
                InventoryHelper.transferSlotAtoSlotB(attached, i, (IItemHandler)this.stack, 0, this.getMaxTransfer());
            }
        }
    }

    protected int getMaxTransfer() {
        return this.getUpgradeLevel(Upgrade.STACK_SIZE) > 0 ? 64 : 1;
    }

    @Override
    protected boolean processPosition(BlockPos pingPos, IItemHandler attached, IPipe pipe) {
        if (pipe == null) {
            return true;
        }
        int maxTransfer = this.stack.getStackLevel();
        for (EnumFacing facing : FacingHelper.getRandomFaceOrder()) {
            IItemHandler capability = pipe.getCapability((IBlockAccess)this.holder.func_145831_w(), pingPos, facing, CapGetter.ItemHandler);
            if (capability == null || (maxTransfer -= InventoryHelper.transfer((IItemHandler)this.stack, 0, capability, maxTransfer, true)) != 0) continue;
            break;
        }
        if (this.stack.isEmpty()) {
            this.ping.resetPosition();
            return false;
        }
        return true;
    }

    @Override
    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.holder.func_145831_w().field_72995_K) {
            this.holder.openGui(playerIn, this);
        }
        return true;
    }

    @Override
    public IItemHandler getHandler(TileEntity tile) {
        return CapGetter.ItemHandler.getInterface((ICapabilityProvider)tile, this.side.func_176734_d());
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new TransferNodeItemContainer(player);
    }

    @Override
    public <T> T getInterface(TileEntity tileEntity, CapGetter<T> capability) {
        IItemHandler handler;
        if (capability == CapGetter.ItemHandler && (handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new IItemHandler(){

                public int getSlots() {
                    return handler.getSlots();
                }

                public ItemStack getStackInSlot(int slot) {
                    return handler.getStackInSlot(slot);
                }

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    return stack;
                }

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return null;
                }
            };
        }
        return super.getInterface(tileEntity, capability);
    }

    @Override
    public GrocketType getType() {
        return GrocketType.TRANSFER_NODE_ITEMS;
    }

    public class TransferNodeItemContainer
    extends DynamicContainerTile {
        public TransferNodeItemContainer(EntityPlayer player) {
            super(TransferNodeItem.this.holder, 9, 64);
            this.addTitle("Transfer Node");
            int numUpgradeSlots = TransferNodeItem.this.upgradeHandler.getSlots();
            for (int i = 0; i < numUpgradeSlots; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)TransferNodeItem.this.upgradeHandler, i, 85 + i * 18 - 9 * numUpgradeSlots, 80));
            }
            this.addWidget(TransferNodeItem.this.filter.newSlot(4, 80));
            this.addWidget(new WidgetSlotItemHandler((IItemHandler)TransferNodeItem.this.stack, 0, 76, 31));
            this.addWidget(new TransferNodeBase.WidgetPingPosition(4, 68));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    public static class Retrieve
    extends TransferNodeItem {
        @Override
        public GrocketType getType() {
            return GrocketType.TRANSFER_NODE_ITEMS_RETRIEVE;
        }

        @Override
        protected boolean shouldAdvance() {
            return !this.stack.isFull();
        }

        @Override
        protected void processBuffer(IItemHandler attached) {
            if (attached == null || this.stack.isEmpty()) {
                return;
            }
            for (int i = 0; i < attached.getSlots() && !this.stack.isEmpty(); ++i) {
                InventoryHelper.transferSlotAtoSlotB((IItemHandler)this.stack, 0, attached, i, 64);
            }
        }

        @Override
        protected boolean processPosition(BlockPos pingPos, IItemHandler attached, IPipe pipe) {
            if (pipe == null || this.stack.isFull()) {
                return true;
            }
            int maxTransfer = this.getMaxTransfer();
            for (EnumFacing facing : FacingHelper.getRandomFaceOrder()) {
                IItemHandler capability = pipe.getCapability((IBlockAccess)this.holder.func_145831_w(), pingPos, facing, CapGetter.ItemHandler);
                if (capability == null) continue;
                for (int i = 0; i < capability.getSlots() && !this.stack.isFull(); ++i) {
                    InventoryHelper.transferSlotAtoSlotB(capability, i, (IItemHandler)this.stack, 0, maxTransfer);
                }
                if (!this.stack.isFull()) continue;
                break;
            }
            return true;
        }
    }
}

