/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.blockaccess;

import com.rwtema.extrautils2.utils.blockaccess.CompatBlockAccess;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThreadSafeBlockAccess
extends CompatBlockAccess
implements IBlockAccess {
    public final Long2ObjectMap<Chunk> chunkMap;
    WorldServer world;

    public ThreadSafeBlockAccess(WorldServer world) {
        this.world = world;
        this.chunkMap = world.func_72863_F().field_73244_f;
    }

    public Chunk getChunk(BlockPos pos) {
        long p_76164_1_ = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        return (Chunk)this.chunkMap.get(p_76164_1_);
    }

    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return null;
        }
        Map map = chunk.func_177434_r();
        TileEntity tileEntity = (TileEntity)map.get(pos);
        if (tileEntity == null || tileEntity.func_145837_r() || !pos.equals((Object)tileEntity.func_174877_v())) {
            return null;
        }
        return tileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
        return 0;
    }

    @Nonnull
    public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return chunk.func_177435_g(pos);
    }

    public boolean func_175623_d(@Nonnull BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Biome func_180494_b(@Nonnull BlockPos pos) {
        return Biomes.field_76767_f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean extendedLevelsInChunkCache() {
        return false;
    }

    public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        IBlockState iblockstate = this.func_180495_p(pos);
        return iblockstate.func_177230_c().func_176211_b(iblockstate, (IBlockAccess)this, pos, direction);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null || chunk.func_76621_g()) {
            return _default;
        }
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }
}

