/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;

public class NBTCopyHelper {
    public static boolean isMutable(int type) {
        return type == 7 || type == 9 || type == 10 || type == 11;
    }

    public static ResultNBT copyAndHashNBT(NBTTagCompound tag) {
        int hash = 10;
        NBTTagCompound copy = new NBTTagCompound();
        for (String s : tag.func_150296_c()) {
            Result result = NBTCopyHelper.copyAndHash(tag.func_74781_a(s));
            hash += s.hashCode() ^ result.hash;
            copy.func_74782_a(s, result.base);
        }
        return new ResultNBT(copy, hash);
    }

    public static Result copyAndHash(NBTBase base) {
        byte id = base.func_74732_a();
        switch (id) {
            case 1: {
                NBTTagByte cache = Cache.getCachedByte(((NBTTagByte)base).func_150290_f());
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 3: {
                NBTTagInt cache = Cache.toCachedInt((NBTTagInt)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 10: {
                int hash = 10;
                NBTTagCompound copy = new NBTTagCompound();
                NBTTagCompound tag = (NBTTagCompound)base;
                for (String s : tag.func_150296_c()) {
                    Result result = NBTCopyHelper.copyAndHash(tag.func_74781_a(s));
                    hash += s.hashCode() ^ result.hash;
                    copy.func_74782_a(s, result.base);
                }
                return new Result((NBTBase)copy, hash);
            }
            case 9: {
                NBTTagList list = (NBTTagList)base;
                int tagType = list.func_150303_d();
                if (tagType == 0) {
                    return new Result((NBTBase)list.func_74737_b(), list.hashCode());
                }
                NBTTagList copy = new NBTTagList();
                int hash = 9;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Result result = NBTCopyHelper.copyAndHash(list.func_179238_g(i));
                    hash = hash * 31 + result.hash;
                    copy.func_74742_a(result.base);
                }
                return new Result((NBTBase)copy, hash);
            }
            case 7: 
            case 11: {
                return new Result(base.func_74737_b(), base.hashCode());
            }
        }
        return new Result(base, base.hashCode());
    }

    public static boolean equal(NBTBase a, NBTBase b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        byte id = a.func_74732_a();
        if (id != b.func_74732_a()) {
            return false;
        }
        if (id == 10) {
            return NBTCopyHelper.equalNBT((NBTTagCompound)a, (NBTTagCompound)b);
        }
        if (id == 9) {
            return NBTCopyHelper.equalTagList((NBTTagList)a, (NBTTagList)b);
        }
        return a.equals((Object)b);
    }

    public static boolean equalTagList(NBTTagList a, NBTTagList b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int tagCount = a.func_74745_c();
        if (tagCount != b.func_74745_c()) {
            return false;
        }
        if (a.func_150303_d() != b.func_150303_d()) {
            return false;
        }
        for (int i = 0; i < tagCount; ++i) {
            if (NBTCopyHelper.equal(a.func_179238_g(i), b.func_179238_g(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalNBT(NBTTagCompound a, NBTTagCompound b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Set aKeys = a.func_150296_c();
        Set bKeys = b.func_150296_c();
        if (aKeys.size() != bKeys.size()) {
            return false;
        }
        for (String aKey : aKeys) {
            if (NBTCopyHelper.equal(a.func_74781_a(aKey), b.func_74781_a(aKey))) continue;
            return false;
        }
        return true;
    }

    public static class Cache {
        static final NBTTagByte FALSE;
        static final NBTTagByte TRUE;
        static final NBTTagByte[] BYTE_CACHE;
        static final NBTTagInt[] INT_CACHE;

        public static NBTTagByte getCacheBoolean(boolean b) {
            return b ? TRUE : FALSE;
        }

        public static NBTTagByte getCachedByte(byte b) {
            return BYTE_CACHE[b + 128];
        }

        public static NBTTagInt toCachedInt(NBTTagInt original) {
            int i = original.func_150287_d();
            if (i >= -128 && i <= 127) {
                return INT_CACHE[i + 128];
            }
            return original;
        }

        public static NBTTagInt getCachedInt(int i) {
            if (i >= -128 && i <= 127) {
                return INT_CACHE[i + 128];
            }
            return new NBTTagInt(i);
        }

        static {
            int i;
            BYTE_CACHE = new NBTTagByte[256];
            INT_CACHE = new NBTTagInt[256];
            for (i = 0; i < BYTE_CACHE.length; ++i) {
                Cache.BYTE_CACHE[i] = new NBTTagByte((byte)(i - 128));
            }
            FALSE = BYTE_CACHE[0];
            TRUE = BYTE_CACHE[1];
            for (i = 0; i < INT_CACHE.length; ++i) {
                Cache.INT_CACHE[i] = new NBTTagInt(i - 128);
            }
        }
    }

    public static class Result {
        public final NBTBase base;
        public final int hash;

        public Result(NBTBase base, int hash) {
            this.base = base;
            this.hash = hash;
        }
    }

    public static class ResultNBT {
        public final NBTTagCompound copy;
        public final int hash;

        public ResultNBT(NBTTagCompound copy, int hash) {
            this.copy = copy;
            this.hash = hash;
        }
    }
}

