/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.block;

import codechicken.chunkloader.block.EnumChunkLoaderType;
import codechicken.chunkloader.block.property.PropertyChunkLoaderType;
import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.chunkloader.tile.TileSpotLoader;
import codechicken.core.ServerUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChunkLoader
extends BlockContainer {
    public static final PropertyChunkLoaderType TYPE = PropertyChunkLoaderType.create("type");

    public BlockChunkLoader() {
        super(Material.field_151576_e);
        this.func_149711_c(20.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumChunkLoaderType.FULL)));
        this.func_149752_b(100.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB currBox = this.getBoundingBoxForType((EnumChunkLoaderType)((Object)state.func_177229_b((IProperty)TYPE)));
        return currBox != null ? currBox : super.func_185496_a(state, source, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        BlockChunkLoader.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !((EnumChunkLoaderType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)TYPE))).equals((Object)EnumChunkLoaderType.SPOT) && side == EnumFacing.DOWN;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public AxisAlignedBB getBoundingBoxForType(EnumChunkLoaderType type) {
        switch (type) {
            case FULL: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
            }
            case SPOT: {
                return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.4375, 0.75);
            }
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumChunkLoaderType type = (EnumChunkLoaderType)((Object)state.func_177229_b((IProperty)TYPE));
        if (type.equals((Object)EnumChunkLoaderType.SPOT) || player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            TileChunkLoader tile = (TileChunkLoader)world.func_175625_s(pos);
            if (tile.owner == null || tile.owner.equals(player.func_70005_c_()) || ChunkLoaderManager.opInteract() && ServerUtils.isPlayerOP((String)player.func_70005_c_())) {
                PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 12);
                packet.writeCoord(new BlockCoord(pos));
                packet.sendToPlayer(player);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chickenchunks.accessdenied", new Object[0]));
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileChunkLoaderBase loader = (TileChunkLoaderBase)world.func_175625_s(pos);
        loader.onBlockPlacedBy(placer);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == 0) {
            return new TileChunkLoader();
        }
        if (meta == 1) {
            return new TileSpotLoader();
        }
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumChunkLoaderType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumChunkLoaderType.values()[meta]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

