/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.manager;

import codechicken.chunkloader.manager.PlayerChunkViewerManager;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.CommonUtils;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerTracker {
    private final PlayerChunkViewerManager manager;
    public final EntityPlayer owner;
    private HashSet<Integer> knownTickets = new HashSet();

    public PlayerChunkViewerTracker(EntityPlayer player, PlayerChunkViewerManager manager) {
        this.owner = player;
        this.manager = manager;
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 1);
        packet.sendToPlayer(player);
        for (WorldServer world : DimensionManager.getWorlds()) {
            this.loadDimension(world);
        }
    }

    public void writeTicketToPacket(PacketCustom packet, ForgeChunkManager.Ticket ticket, Collection<ChunkPos> chunkSet) {
        packet.writeInt(this.manager.ticketIDs.get(ticket).intValue());
        packet.writeString(ticket.getModId());
        String player = ticket.getPlayerName();
        packet.writeBoolean(player != null);
        if (player != null) {
            packet.writeString(player);
        }
        packet.writeByte(ticket.getType().ordinal());
        Entity entity = ticket.getEntity();
        if (entity != null) {
            packet.writeInt(entity.func_145782_y());
        }
        packet.writeShort(chunkSet.size());
        for (ChunkPos chunk : chunkSet) {
            packet.writeInt(chunk.field_77276_a);
            packet.writeInt(chunk.field_77275_b);
        }
        this.knownTickets.add(this.manager.ticketIDs.get(ticket));
    }

    public void loadDimension(WorldServer world) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 2);
        int dim = CommonUtils.getDimension((World)world);
        packet.writeInt(dim);
        Collection allchunks = world.func_72863_F().func_189548_a();
        packet.writeInt(allchunks.size());
        for (Chunk chunk : allchunks) {
            packet.writeInt(chunk.field_76635_g);
            packet.writeInt(chunk.field_76647_h);
        }
        ImmutableMap tickets = ForgeChunkManager.getPersistentChunksFor((World)world).inverse().asMap();
        packet.writeInt(tickets.size());
        for (Map.Entry entry : tickets.entrySet()) {
            this.writeTicketToPacket(packet, (ForgeChunkManager.Ticket)entry.getKey(), (Collection)entry.getValue());
        }
        packet.sendToPlayer(this.owner);
    }

    public void unloadDimension(int dim) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 3);
        packet.writeInt(dim);
        packet.sendToPlayer(this.owner);
    }

    public void sendChunkChange(PlayerChunkViewerManager.ChunkChange change) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 4);
        packet.writeInt(change.dimension);
        packet.writeInt(change.chunk.field_77276_a);
        packet.writeInt(change.chunk.field_77275_b);
        packet.writeBoolean(change.add);
        packet.sendToPlayer(this.owner);
    }

    public void sendTicketChange(PlayerChunkViewerManager.TicketChange change) {
        int ticketID = this.manager.ticketIDs.get(change.ticket);
        if (!this.knownTickets.contains(ticketID)) {
            this.addTicket(change.dimension, change.ticket);
        }
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 5);
        packet.writeInt(change.dimension);
        packet.writeInt(ticketID);
        packet.writeInt(change.chunk.field_77276_a);
        packet.writeInt(change.chunk.field_77275_b);
        packet.writeBoolean(change.force);
        packet.sendToPlayer(this.owner);
    }

    public void updatePlayer(EntityPlayer player) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 6);
        packet.writeString(player.func_70005_c_());
        packet.writeInt(player.field_71093_bK);
        Vector3 pos = Vector3.fromEntity((Entity)player);
        packet.writeFloat((float)pos.x);
        packet.writeFloat((float)pos.y);
        packet.writeFloat((float)pos.z);
        packet.sendToPlayer(this.owner);
    }

    public void removePlayer(String username) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 7);
        packet.writeString(username);
        packet.sendToPlayer(this.owner);
    }

    public void addTicket(int dimension, ForgeChunkManager.Ticket ticket) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 8);
        packet.writeInt(dimension);
        this.writeTicketToPacket(packet, ticket, (Collection<ChunkPos>)ticket.getChunkList());
        packet.sendToPlayer(this.owner);
    }
}

