/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.network;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.gui.GuiChunkLoader;
import codechicken.chunkloader.gui.PlayerChunkViewer;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.CommonUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ChunkLoaderCPH
implements PacketCustom.IClientPacketHandler {
    public static String channel = "ChickenChunks";

    public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient handler) {
        switch (packet.getType()) {
            case 1: {
                PlayerChunkViewer.openViewer((int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70161_v, CommonUtils.getDimension((World)mc.field_71441_e));
                break;
            }
            case 2: {
                PlayerChunkViewer.instance().loadDimension(packet, mc.field_71441_e);
                break;
            }
            case 3: {
                PlayerChunkViewer.instance().unloadDimension(packet.readInt());
                break;
            }
            case 4: {
                PlayerChunkViewer.instance().handleChunkChange(packet.readInt(), new ChunkPos(packet.readInt(), packet.readInt()), packet.readBoolean());
                break;
            }
            case 5: {
                PlayerChunkViewer.instance().handleTicketChange(packet.readInt(), packet.readInt(), new ChunkPos(packet.readInt(), packet.readInt()), packet.readBoolean());
                break;
            }
            case 6: {
                PlayerChunkViewer.instance().handlePlayerUpdate(packet.readString(), packet.readInt(), new Vector3((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat()));
                break;
            }
            case 7: {
                PlayerChunkViewer.instance().removePlayer(packet.readString());
                break;
            }
            case 8: {
                PlayerChunkViewer.instance().handleNewTicket(packet, mc.field_71441_e);
                break;
            }
            case 12: {
                BlockCoord pos = packet.readCoord();
                TileEntity tile = mc.field_71441_e.func_175625_s(pos.pos());
                if (!(tile instanceof TileChunkLoader)) break;
                mc.func_147108_a((GuiScreen)new GuiChunkLoader((TileChunkLoader)tile));
            }
        }
    }

    public static void sendGuiClosing() {
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.sendToServer();
    }

    public static void sendShapeChange(TileChunkLoader tile, ChunkLoaderShape shape, int radius) {
        PacketCustom packet = new PacketCustom((Object)channel, 2);
        packet.writeCoord(new BlockCoord(tile.func_174877_v()));
        packet.writeByte(shape.ordinal());
        packet.writeByte(radius);
        packet.sendToServer();
    }
}

