/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.api.IChickenChunkLoader;
import codechicken.chunkloader.client.TileChunkLoaderRenderer;
import codechicken.chunkloader.init.ModBlocks;
import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketTile;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileChunkLoaderBase
extends TileEntity
implements ITickable,
IChickenChunkLoader,
ICustomPacketTile {
    public String owner;
    protected boolean loaded = false;
    protected boolean powered = false;
    public TileChunkLoaderRenderer.RenderInfo renderInfo;
    public boolean active = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("powered", this.powered);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("owner")) {
            this.owner = tag.func_74779_i("owner");
        }
        if (tag.func_74764_b("powered")) {
            this.powered = tag.func_74767_n("powered");
        }
        this.loaded = true;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && this.loaded && !this.powered) {
            this.activate();
        }
        if (this.field_145850_b.field_72995_K) {
            this.renderInfo = new TileChunkLoaderRenderer.RenderInfo();
        }
    }

    public boolean isPowered() {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            boolean isPowered = TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.func_174877_v().func_177972_a(face), face);
            if (!isPowered) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoweringTo(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().func_180656_a(state, (IBlockAccess)world, pos, side) > 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.deactivate();
        }
    }

    public void destroyBlock() {
        ModBlocks.blockChunkLoader.func_176226_b(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    public ChunkPos getChunkPosition() {
        return new ChunkPos(this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        if (entityliving instanceof EntityPlayer) {
            this.owner = entityliving.func_70005_c_();
        }
        if (this.owner.equals("")) {
            this.owner = null;
        }
        this.activate();
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Object getMod() {
        return ChickenChunks.instance;
    }

    @Override
    public World getLoaderWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockCoord getPosition() {
        return new BlockCoord((TileEntity)this);
    }

    @Override
    public void deactivate() {
        this.loaded = true;
        this.active = false;
        ChunkLoaderManager.remChunkLoader(this);
    }

    @Override
    public void activate() {
        this.loaded = true;
        this.active = true;
        ChunkLoaderManager.addChunkLoader(this);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean nowPowered = this.isPowered();
            if (this.powered != nowPowered) {
                this.powered = nowPowered;
                if (this.powered) {
                    this.deactivate();
                } else {
                    this.activate();
                }
            }
        } else {
            this.renderInfo.update(this);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 10);
        this.writeToPacket((MCDataOutput)packet);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, packet.toNBTTag());
    }

    public NBTTagCompound func_189517_E_() {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 10);
        this.writeToPacket((MCDataOutput)packet);
        return packet.toNBTTag(super.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromPacket((MCDataInput)PacketCustom.fromTilePacket((SPacketUpdateTileEntity)pkt));
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromPacket((MCDataInput)PacketCustom.fromNBTTag((NBTTagCompound)tag));
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeString(this.owner);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.active = packet.readBoolean();
        if (packet.readBoolean()) {
            this.owner = packet.readString();
        }
    }
}

