/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape;

import com.google.common.collect.Sets;
import gigaherz.packingtape.ISideProxy;
import gigaherz.packingtape.tape.BlockPackaged;
import gigaherz.packingtape.tape.ItemTape;
import gigaherz.packingtape.tape.TilePackaged;
import java.util.Collections;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="packingtape", version="0.6.0", acceptedMinecraftVersions="[1.9.4,1.11.0)", dependencies="required-after:Forge@[12.16.0.1825,)")
public class ModPackingTape {
    public static final String MODID = "packingtape";
    public static final String VERSION = "0.6.0";
    public static final Set<String> blackList = Sets.newHashSet();
    public static final Set<String> whiteList = Sets.newHashSet();
    public static BlockPackaged packagedBlock;
    public static Item itemTape;
    @Mod.Instance(value="packingtape")
    public static ModPackingTape instance;
    @SidedProxy(clientSide="gigaherz.packingtape.client.ClientProxy", serverSide="gigaherz.packingtape.server.ServerProxy")
    public static ISideProxy proxy;
    public static Logger logger;
    public static int tapeRollUses;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        Property bl = config.get("tileEntities", "blacklist", new String[0]);
        Property wl = config.get("tileEntities", "whitelist", new String[0]);
        Property ru = config.get("tapeRoll", "numberOfUses", 8);
        Collections.addAll(blackList, bl.getStringList());
        Collections.addAll(whiteList, wl.getStringList());
        tapeRollUses = ru.getInt();
        if (!(bl.wasRead() && wl.wasRead() && ru.wasRead())) {
            config.save();
        }
        itemTape = new ItemTape("itemTape");
        GameRegistry.register((IForgeRegistryEntry)itemTape);
        packagedBlock = new BlockPackaged("packagedBlock");
        GameRegistry.register((IForgeRegistryEntry)packagedBlock);
        GameRegistry.register((IForgeRegistryEntry)packagedBlock.createItemBlock());
        GameRegistry.registerTileEntity(TilePackaged.class, (String)"tilePackagedBlock");
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemTape, 1), (Object[])new Object[]{Items.field_151123_aH, Items.field_151007_F, Items.field_151121_aF});
    }

    public static boolean isTileEntityAllowed(TileEntity te) {
        String cn = te.getClass().getCanonicalName();
        if (whiteList.contains(cn)) {
            return true;
        }
        if (blackList.contains(cn)) {
            return false;
        }
        if (te.getClass().equals(TileEntityCommandBlock.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntityEndPortal.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntityMobSpawner.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntitySkull.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntitySign.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntityBanner.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntityComparator.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntityDaylightDetector.class)) {
            return false;
        }
        if (te.getClass().equals(TileEntityPiston.class)) {
            return false;
        }
        return !te.getClass().equals(TileEntityNote.class);
    }
}

