/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import com.google.common.collect.Lists;
import gigaherz.packingtape.ModPackingTape;
import gigaherz.packingtape.tape.TilePackaged;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPackaged
extends Block {
    public BlockPackaged(String name) {
        super(Material.field_151580_n);
        this.setRegistryName(name);
        this.func_149663_c("packingtape." + name);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePackaged();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Item item = Item.func_150898_a((Block)this);
        assert (item != null);
        if (player.field_71075_bZ.field_75098_d && GuiScreen.func_146271_m()) {
            return new ItemStack(item, 1);
        }
        return new ItemStack(ModPackingTape.itemTape, 1);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList drops = Lists.newArrayList();
        TileEntity teWorld = world.func_175625_s(pos);
        if (teWorld != null && teWorld instanceof TilePackaged) {
            TilePackaged packaged = (TilePackaged)teWorld;
            ItemStack stack = packaged.getPackedStack();
            drops.add(stack);
        }
        return drops;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!placer.func_70093_af() && placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            TilePackaged te = (TilePackaged)worldIn.func_175625_s(pos);
            assert (te != null);
            te.setPreferredDirection(EnumFacing.func_176733_a((double)player.func_70079_am()).func_176734_d());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TilePackaged te = (TilePackaged)worldIn.func_175625_s(pos);
        assert (te != null);
        if (te.getContainedBlock() == null) {
            return false;
        }
        if (!Block.field_149771_c.func_148741_d((Object)te.getContainedBlock())) {
            return false;
        }
        Block b = (Block)Block.field_149771_c.func_82594_a((Object)te.getContainedBlock());
        IBlockState newState = b.func_176203_a(te.getContainedMetadata());
        NBTTagCompound tag = te.getContainedTile();
        if (tag == null) {
            return false;
        }
        worldIn.func_175656_a(pos, newState);
        EnumFacing preferred = te.getPreferredDirection();
        if (preferred != null) {
            PropertyEnum facing = null;
            for (IProperty prop : newState.func_177227_a()) {
                if (!prop.func_177701_a().equalsIgnoreCase("facing") && !prop.func_177701_a().equalsIgnoreCase("rotation")) continue;
                if (!(prop instanceof PropertyEnum)) break;
                facing = (PropertyEnum)prop;
                break;
            }
            if (facing != null && facing.func_177699_b() == EnumFacing.class && facing.func_177700_c().contains(preferred) && !BlockPackaged.rotateBlockToward(worldIn, pos, preferred, facing)) {
                worldIn.func_175656_a(pos, newState);
            }
        }
        BlockPackaged.setTileEntityNBT(worldIn, pos, tag, playerIn);
        return true;
    }

    private static boolean rotateBlockToward(World worldIn, BlockPos pos, EnumFacing preferred, PropertyEnum prop) {
        IBlockState stored = worldIn.func_180495_p(pos);
        Block block = stored.func_177230_c();
        IBlockState actual = stored.func_185899_b((IBlockAccess)worldIn, pos);
        if (actual.func_177229_b((IProperty)prop) == preferred) {
            return true;
        }
        for (Object ignored : prop.func_177700_c()) {
            if (preferred.func_176740_k() == EnumFacing.Axis.Y) {
                block.rotateBlock(worldIn, pos, EnumFacing.WEST);
            } else {
                block.rotateBlock(worldIn, pos, EnumFacing.UP);
            }
            stored = worldIn.func_180495_p(pos);
            block = stored.func_177230_c();
            actual = stored.func_185899_b((IBlockAccess)worldIn, pos);
            if (actual.func_177229_b((IProperty)prop) != preferred) continue;
            return true;
        }
        return false;
    }

    public static boolean setTileEntityNBT(World worldIn, BlockPos pos, @Nullable NBTTagCompound tag, @Nullable EntityPlayer playerIn) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        if (tag != null && (tileentity = worldIn.func_175625_s(pos)) != null) {
            if (!(worldIn.field_72995_K || !tileentity.func_183000_F() || playerIn != null && playerIn.func_189808_dh())) {
                return false;
            }
            NBTTagCompound merged = new NBTTagCompound();
            NBTTagCompound empty = merged.func_74737_b();
            tileentity.func_189515_b(merged);
            merged.func_179237_a(tag);
            merged.func_74768_a("x", pos.func_177958_n());
            merged.func_74768_a("y", pos.func_177956_o());
            merged.func_74768_a("z", pos.func_177952_p());
            if (!merged.equals((Object)empty)) {
                tileentity.func_145839_a(merged);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tooltip.add("Missing data (no nbt)!");
            return;
        }
        NBTTagCompound info = (NBTTagCompound)tag.func_74781_a("BlockEntityTag");
        if (info == null) {
            tooltip.add("Missing data (no tag)!");
            return;
        }
        if (!(info.func_150297_b("containedBlock", 8) && info.func_150297_b("containedBlockMetadata", 3) && info.func_150297_b("containedTile", 10))) {
            tooltip.add("Missing data (no block info)!");
            return;
        }
        String blockName = info.func_74779_i("containedBlock");
        int meta = info.func_74762_e("containedBlockMetadata");
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
        if (block == null) {
            tooltip.add("Unknown block:");
            tooltip.add("  " + blockName);
            return;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            tooltip.add("No ItemBlock:");
            tooltip.add("  " + blockName);
            return;
        }
        tooltip.add("Contains:");
        ItemStack stack1 = new ItemStack(item, 1, meta);
        for (String s : stack1.func_82840_a(player, advanced)) {
            tooltip.add("  " + s);
        }
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }
}

