/*
 * Decompiled with CFR 0.152.
 */
package org.winterblade.minecraft.scripting;

import java.util.List;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import org.winterblade.minecraft.scripting.ScriptExecutionManager;
import org.winterblade.minecraft.scripting.api.INashornMod;
import org.winterblade.minecraft.scripting.internal.AnnotationUtil;
import org.winterblade.minecraft.scripting.internal.ScriptObjectParser;

@Mod(modid="NashornLib", version="1.9.4-1.8.77-1.3.1", acceptedMinecraftVersions="[1.9.4]")
public class NashornLibMod {
    public static final String MODID = "NashornLib";
    public static final String VERSION = "1.9.4-1.8.77-1.3.1";
    private List<INashornMod> nashornMods;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.nashornMods = AnnotationUtil.getNashornMods(evt.getAsmData());
        ScriptObjectParser.registerDeserializerClasses(AnnotationUtil.getScriptObjectDeserializers(evt.getAsmData()));
        logger = evt.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        for (INashornMod mod : this.nashornMods) {
            try {
                mod.onScriptContextCreated(ScriptExecutionManager.getNewContext(mod.getLogger(), mod.getAllowedPackageRoots()));
            }
            catch (Exception ex) {
                logger.error("Error creating script context for '" + mod.getClass().getName() + "'.", (Throwable)ex);
            }
        }
    }
}

