/*
 * Decompiled with CFR 0.152.
 */
package org.winterblade.minecraft.scripting;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.logging.log4j.Logger;
import org.winterblade.minecraft.scripting.api.IScriptContext;
import org.winterblade.minecraft.scripting.internal.JsonHelper;
import org.winterblade.minecraft.scripting.internal.ScriptObjectParser;

public class NashornScriptContext
implements IScriptContext {
    private final Logger logger;
    private final ScriptEngine nashorn;

    public NashornScriptContext(Logger logger, ScriptEngine nashorn) {
        this.logger = logger;
        this.nashorn = nashorn;
    }

    @Override
    public boolean eval(String script) throws ScriptException {
        this.nashorn.eval(script);
        return true;
    }

    @Override
    public <T> T convertData(Object input, Class<T> cls) {
        return ScriptObjectParser.convertData(input, cls, this.logger);
    }

    @Override
    public void parseScriptObject(ScriptObjectMirror data, Object writeTo) {
        ScriptObjectParser.writeScriptObjectToClass(data, writeTo, this.logger);
    }

    @Override
    public String stringifyJsonObject(JSObject object) {
        return JsonHelper.getJsonString(object, this.logger);
    }

    @Override
    public Object invokeFunction(String function, Object ... args) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)this.nashorn)).invokeFunction(function, args);
    }
}

