/*
 * Decompiled with CFR 0.152.
 */
package org.winterblade.minecraft.scripting;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.logging.log4j.Logger;
import org.winterblade.minecraft.scripting.NashornLibMod;
import org.winterblade.minecraft.scripting.NashornScriptContext;
import org.winterblade.minecraft.scripting.api.IScriptContext;

public class ScriptExecutionManager {
    private static final ScriptExecutionManager instance = new ScriptExecutionManager();
    private final NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
    private final String header;

    private ScriptExecutionManager() {
        String headerTemp;
        try {
            headerTemp = Resources.toString((URL)Resources.getResource((String)"scripts/NashornLibHeader.js"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            NashornLibMod.logger.error("Unable to load file processing header; things will go badly from here out...", (Throwable)e);
            headerTemp = "";
        }
        this.header = headerTemp;
    }

    public static IScriptContext getNewContext(Logger logger) {
        return ScriptExecutionManager.getNewContext(logger, new String[0]);
    }

    public static IScriptContext getNewContext(Logger logger, String[] allowedPackageRoots) {
        ScriptEngine nashorn = ScriptExecutionManager.instance.factory.getScriptEngine(new ScriptExecutionSandbox(allowedPackageRoots));
        Bindings bindings = nashorn.getBindings(100);
        try {
            nashorn.eval(ScriptExecutionManager.instance.header);
        }
        catch (ScriptException e) {
            NashornLibMod.logger.error("Error processing script header file; please report this issue.", (Throwable)e);
        }
        Invocable invocable = (Invocable)((Object)nashorn);
        try {
            invocable.invokeFunction("__nashornLibInternalConfigureLogger", logger);
        }
        catch (NoSuchMethodException | ScriptException e) {
            NashornLibMod.logger.error("Unable to configure logger", (Throwable)e);
        }
        bindings.remove("exit");
        bindings.remove("quit");
        bindings.remove("load");
        bindings.remove("loadWithNewGlobal");
        return new NashornScriptContext(logger, nashorn);
    }

    private static class ScriptExecutionSandbox
    implements ClassFilter {
        private final String[] allowedPackageRoots;

        ScriptExecutionSandbox(String[] allowedPackageRoots) {
            this.allowedPackageRoots = allowedPackageRoots;
        }

        @Override
        public boolean exposeToScripts(String s) {
            if (s.equals("org.winterblade.minecraft.scripting.ScriptExecutionManager")) {
                return false;
            }
            if (s.equals("org.winterblade.minecraft.scripting.internal.JsonHelper")) {
                return true;
            }
            for (String allowedRoot : this.allowedPackageRoots) {
                if (!s.startsWith(allowedRoot)) continue;
                return true;
            }
            return false;
        }
    }
}

