/*
 * Decompiled with CFR 0.152.
 */
package org.winterblade.minecraft.scripting.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.objectweb.asm.Type;
import org.winterblade.minecraft.scripting.NashornLibMod;
import org.winterblade.minecraft.scripting.api.INashornMod;
import org.winterblade.minecraft.scripting.api.IScriptObjectDeserializer;
import org.winterblade.minecraft.scripting.api.NashornMod;
import org.winterblade.minecraft.scripting.api.ScriptObjectDeserializer;

public class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static Map<Type, Class<IScriptObjectDeserializer>> getScriptObjectDeserializers(@Nonnull ASMDataTable asmDataTable) {
        return AnnotationUtil.getClassMap(asmDataTable, ScriptObjectDeserializer.class, IScriptObjectDeserializer.class, "deserializes");
    }

    public static List<INashornMod> getNashornMods(@Nonnull ASMDataTable asmDataTable) {
        return AnnotationUtil.getInstances(asmDataTable, NashornMod.class, INashornMod.class);
    }

    private static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                NashornLibMod.logger.error("Failed to load: {}", new Object[]{asmData.getClassName(), e});
            }
        }
        return instances;
    }

    private static <T, Tk> Map<Tk, Class<T>> getClassMap(@Nonnull ASMDataTable asmDataTable, Class<?> annotationClass, Class<T> outputClass, String idParam) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmTable = asmDataTable.getAll(annotationClassName);
        HashMap instances = new HashMap();
        for (ASMDataTable.ASMData asmData : asmTable) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                if (!outputClass.isAssignableFrom(asmClass)) {
                    NashornLibMod.logger.warn("Attempted to load '" + asmClass.getSimpleName() + "', but it doesn't implement '" + outputClass.getSimpleName() + "'.");
                    continue;
                }
                Object name = null;
                if (asmData.getAnnotationInfo().containsKey(idParam)) {
                    name = asmData.getAnnotationInfo().get(idParam);
                }
                if (name == null) {
                    NashornLibMod.logger.warn("Attempted to load '" + asmClass.getSimpleName() + "', couldn't find the ID parameter '" + idParam + "' on it.");
                    continue;
                }
                instances.put(name, asmClass);
            }
            catch (ClassNotFoundException e) {
                NashornLibMod.logger.error("Failed to load: " + asmData.getClassName(), (Throwable)e);
            }
        }
        return instances;
    }
}

