/*
 * Decompiled with CFR 0.152.
 */
package org.winterblade.minecraft.scripting.internal;

import jdk.nashorn.api.scripting.JSObject;
import org.apache.logging.log4j.Logger;

public class JsonHelper {
    private static JsonStringifyCallback callbackFunc;

    private JsonHelper() {
    }

    public static void registerCallback(JsonStringifyCallback callback) {
        callbackFunc = callback;
    }

    public static String getJsonString(JSObject o, Logger log) {
        if (callbackFunc == null) {
            log.warn("Internal object hasn't been registered yet.");
            return "";
        }
        try {
            return callbackFunc.stringifyNbt(o);
        }
        catch (Exception e) {
            log.warn("Unable to call JSON.stringify with the provided object.");
            return "";
        }
    }

    @FunctionalInterface
    public static interface JsonStringifyCallback {
        public String stringifyNbt(Object var1);
    }
}

